      double precision function dlycabscft(r)
*     accurate Lyman continuum absorption a_nu, where r in Ryd
*     pi = 3.141592653589793239d0, pi/2=1.57079632679489662d0
*     Accurate for r<22, after which need to sort out arctan ambiguity
      implicit none
      double precision eps,r,x
      double precision temp
      double precision dexpf
      if(r.lt.1.0d0) then
*       energy below threshold
        dlycabscft=0.0d0
       else
        eps=sqrt(r-1.0d0)
        dlycabscft=6.30d-18/(r**4)
*       write(6,*) 'a',dlycabscft
        if(eps.gt.1.0d-5) then
          x=atan(eps)
*         write(6,*) 'e,x',eps,x
          if(x.lt.0.0d0) x=x+3.141592653589793239d0
          dlycabscft=dlycabscft*dexpf(4.0d0*(1.0d0-(x/eps)))/
     1      (1.0d0-dexpf(-6.283185307d0/eps))
        end if
*       write(6,*) 'a2',dlycabscft
      end if
      return
      end
