      double precision function voigt(vin,a)
      implicit none
      double precision a,vin
*
      double precision v,v0
*      double precision v1
      double precision h0(202),h1(202),h2(202),h3(202)
      integer n,p,p1,p2
      double precision x,y,z
*      double precision sqrtpi
      double precision oneonsqrtpi
      double precision r
*      parameter (sqrtpi=1.772453850906d0)
      parameter (oneonsqrtpi=.56418958354775630d0)
       data h0/
     : 1.0d0,
     : .9975031223974601240368798d0,
     : .9900498337491680535739060d0,
     : .9777512371933363639286036d0,
     : .9607894391523232094392107d0,
     : .9394130628134757861197108d0,
     : .9139311852712281867473535d0,
     : .8847059049434835594929548d0,
     : .8521437889662113384563470d0,
     : .8166864825981108401538061d0,
     : .7788007830714048682451703d0,
     : .7389684882589442416058206d0,
     : .6976763260710310572091293d0,
     : .6554062543268405127576690d0,
     : .6126263941844160689885800d0,
     : .5697828247309230097666297d0,
     : .5272924240430485572436946d0,
     : .4855368951540794399916001d0,
     : .4448580662229411344814454d0,
     :  .4055545050633205516443034d0,
     :  .3678794411714423215955238d0,
     :  .3320399453446606420249195d0,
     :  .2981972794298873779316010d0,
     :  .2664682978135241116965901d0,
     :  .2369277586821217567233665d0,
     :  .2096113871510978225241101d0,
     :  .1845195239929892676298138d0,
     :  .1616211924653392539324509d0,
     :  .1408584209210449961479715d0,
     :  .1221506695399900084151679d0,
     :  .1053992245618643367832177d0,
     :  .9049144166369591062935159d-1,
     :  .7730474044329974599046566d-1,
     :  .6571027322750286139200605d-1,
     :  .5557621261148306865356766d-1,
     :  .4677062238395898365276137d-1,
     :  .3916389509898707373977109d-1,
     :  .3263075599289603180381419d-1,
     :  .2705184686635041108596167d-1,
     :  .2231491477696640649487920d-1,
     :  .1831563888873418029371802d-1,
     :  .1495813470057748930092482d-1,
     :  .1215517832991493721502629d-1,
     :  .9828194835379685936011149d-2,
     :  .7907054051593440493635646d-2,
     :  .6329715427485746576865117d-2,
     :  .5041760259690979102410257d-2,
     :  .3995845830084632413030896d-2,
     :  .3151111598444440557819106d-2,
     :  .2472563035874193226953048d-2,
     :  .1930454136227709242213512d-2,
     :  .1499685289329846120368399d-2,
     :  .1159229173904591150012118d-2,
     :  .8915937199952195568639939d-3,
     :  .6823280527563766163014506d-3,
     :  .5195746821548384817648154d-3,
     :  .3936690406550782109805393d-3,
     :  .2967857677932108344855019d-3,
     :  .2226298569188890101840659d-3,
     :  .1661698666072774484528398d-3,
     :  .1234098040866795494976367d-3,
     :  .9119595636226606575873788d-4,
     :  .6705482430281108867614262d-4,
     :  .4905835745620769579106241d-4,
     :  .3571284964163521691234528d-4,
     :  .2586810022265412127035909d-4,
     :  .1864374233151683041526522d-4,
     :  .1336996212084380475632834d-4,
     :  .9540162873079234841590110d-5,
     :  .6773449997703748098370991d-5,
     :  .4785117392129009089609771d-5,
     :  .3363595724825637829225185d-5,
     :  .2352575200009772922652510d-5,
     :  .1637237807196195233271403d-5,
     :  .1133727138747965652009438d-5,
     :  .7811489408304490795473004d-6,
     :  .5355347802793106157479094d-6,
     :  .3653171341207511214363159d-6,
     :  .2479596018045029629499234d-6,
     :  .1674635703137489046698250d-6,
     :  .1125351747192591145137752d-6,
     :  .7524623257644829651017174d-7,
     :  .5006218020767042215644986d-7,
     :  .3314082270898834287088712d-7,
     :  .2182957795125479209083827d-7,
     :  .1430724191856768833467676d-7,
     :  .9330287574504991120387842d-8,
     :  .6054282282484886644264747d-8,
     :  .3908938434264861859681131d-8,
     :  .2511212833271291589987176d-8,
     :  .1605228055185611608653934d-8,
     :  .1020982947159334870301705d-8,
     :  .6461431773106108989429857d-9,
     :  .4068811450655793356678124d-9,
     :  .2549381880391968872012880d-9,
     :  .1589391009451636652873474d-9,
     :  .9859505575991508240729766d-10,
     :  .6085665105518337082108266d-10,
     :  .3737571327944262032923964d-10,
     :  .2284017657993705413027994d-10,
     :  .1388794386496402059466176d-10,
     :  .8402431396484308187150245d-11,
     :  .5058252742843793235026422d-11,
     :  .3029874246723653849216172d-11,
     :  .1805831437513215621913785d-11,
     :  .1070923238250807645586450d-11,
     :  .6319285885175366663984108d-12,
     :  .3710275783094727281418983d-12,
     :  .2167568882618961942307398d-12,
     :  .1259993054847742150188394d-12,
     :  .7287724095819692419343177d-13,
     :  .4194152536192217185131208d-13,
     :  .2401734781620959445230543d-13,
     :  .1368467228126496785536523d-13,
     :  .7758402075696070467242451d-14,
     :  .4376618502870849893821267d-14,
     :  .2456595368792144453705261d-14,
     :  .1372009419645128473380053d-14,
     :  .7624459905389739760616425d-15,
     :  .4215893238174252040735029d-15,
     :  .2319522830243569388312264d-15,
     :  .1269802641377875575018264d-15,
     :  .6916753975541448863883054d-16,
     :  .3748840457745443581785685d-16,
     :  .2021715848695342027119482d-16,
     :  .1084855264042937802512215d-16,
     :  .5792312885394857923477507d-17,
     :  .3077235638152508657901574d-17,
     :  .1626664621453244338034305d-17,
     :  .8555862896902856300749061d-18,
     :  .4477732441718301199042103d-18,
     :  .2331744656246116743545942d-18,
     :  .1208182019899973571654094d-18,
     :  .6228913128535643653088166d-19,
     :  .3195366717748344275120932d-19,
     :  .1631013922670185678641901d-19,
     :  .8283677007682876110228791d-20,
     :  .4186173006145967657832773d-20,
     :  .2104939978339734445589080d-20,
     :  .1053151347744013743766989d-20,
     :  .5242885663363463937171805d-21,
     :  .2597039249246848208769072d-21,
     :  .1280015319051641983953037d-21,
     :  .6277407889747195099574399d-22,
     :  .3063190864577440373821128d-22,
     :  .1487292181651270619154227d-22,
     :  .7185335635902193010046941d-23,
     :  .3454031957013868448981675d-23,
     :  .1652091782314268593068387d-23,
     :  .7862678502984538622254116d-24,
     :  .3723363121750510429289070d-24,
     :  .1754400713566556605465117d-24,
     :  .8225280651606668501925640d-25,
     :  .3837082905344536379879530d-25,
     :  .1781066634757091357021587d-25,
     :  .8225980595143903024275237d-26,
     :  .3780277844776084635218009d-26,
     :  .1728575244037268289032505d-26,
     :  .7864685935766448441713277d-27,
     :  .3560434556451067378310069d-27,
     :  .1603810890548637852976087d-27,
     :  .7188393394953158727447087d-28,
     :  .3205819323394999444158648d-28,
     :  .1422573701362478490703169d-28,
     :  .6281148147605989215436687d-29,
     :  .2759509067522042024589005d-29,
     :  .1206293927781149203841840d-29,
     :  .5246902396795390138796640d-30,
     :  .2270812922026396509517690d-30,
     :  .9778860615814667663870901d-31,
     :  .4190093194494397377123780d-31,
     :  .1786436718517518413888050d-31,
     :  .7578445267618382646037748d-32,
     :  .3198903416725805416294188d-32,
     :  .1343540197758737662452134d-32,
     :  .5614728092387934579799402d-33,
     :  .2334722783487267408869808d-33,
     :  .9659851300583384710233199d-34,
     :  .3976803097901655265751816d-34,
     :  .1629019426220514693169818d-34,
     :  .6639677199580734400702255d-35,
     :  .2692751000456178970430831d-35,
     :  .1086610640745980532852592d-35,
     :  .4362950029268711046345153d-36,
     :  .1743070896645292498913954d-36,
     :  .6929124938815710000577778d-37,
     :  .2740755284722598699701951d-37,
     :  .1078675105373929991550997d-37,
     :  .4224152406206200437573993d-38,
     :  .1645951484063258284098658d-38,
     :  .6381503448060790393554118d-39,
     :  .2461826907787885454919214d-39,
     :  .9449754976491185028813549d-40,
     :  .3609209642415355020302235d-40,
     :  .1371614910949353618952282d-40,
     :  .5186576811908572940413120d-41,
     :  .1951452380295377748121319d-41,
     :  .7305730197111493885868359d-42,
     :  .2721434140093713884466599d-42,
     :  .1008696596314342558322441d-42,
     :  .3720075976020835962959696d-43,
     :  .1365122395620087240477630d-43/

       data h1/
     :  -1.128379167095512573896159d0,
     :  -1.122746665023313894112994d0,
     :  -1.105961434222613497822717d0,
     :  -1.078356949458362356972974d0,
     :  -1.040477963566390226869037d0,
     :  -.9930644092865188274925694d0,
     :  -.9370297574325730524254160d0,
     :  -.8734346738611667009559691d0,
     :  -.8034569860177944012914767d0,
     :  -.7283590897795191457635390d0,
     :  -.6494539941944691013512214d0,
     :  -.5680712138345335512208471d0,
     :  -.4855236771153186839197872d0,
     :  -.4030767281964792012404736d0,
     :  -.3219201665209207840831093d0,
     :  -.2431441002236951675148354d0,
     :  -.1677191974661332963609891d0,
     :  -.9648171389061105293546881d-1,
     :  -.3012346558870770535102483d-1,
     :  .3081328457047809980986685d-1,
     :  .8593624458727488433391777d-1,
     :  .1349991935349749351748713d0,
     :  .1778942744880748462232135d0,
     :  .2146410885736963723412265d0,
     :  .2453732617833523433216744d0,
     :  .2703231847626659615037426d0,
     :  .2898056218155761132507312d0,
     :  .3042008523837261147222841d0,
     :  .3139379509747736418513567d0,
     :  .3194787353320834397089635d0,
     :  .3213028233267945998845488d0,
     :  .3198941423604233541674753d0,
     :  .3157291364070343763776039d0,
     :  .3092668200208504802085382d0,
     :  .3009407397271468294117335d0,
     :  .2911528243392948676821857d0,
     :  .2802690390913659378360681d0,
     :  .2686167052981096351368975d0,
     :  .2564833079412283848897372d0,
     :  .2441165877658165024921633d0,
     :  .2317257011687522312257119d0,
     :  .2194832289213470945135105d0,
     :  .2075278218310246553881156d0,
     :  .1959672858880207128215797d0,
     :  .1848819293094190730287360d0,
     :  .1743280173110208640535652d0,
     :  .1643412057011470302647273d0,
     :  .1549398500207542791790132d0,
     :  .1461281117364874603340094d0,
     :  .1378988059908943461128856d0,
     :  .1302359559637753421977543d0,
     :  .1231170365911391556632533d0,
     :  .1165149050377156668055896d0,
     :  .1103994269264874144398788d0,
     :  .1047388160423518894772002d0,
     :  .9950071130235648759030670d-1,
     :  .9465301854781620910441970d-1,
     :  .9016454652735125189272609d-1,
     :  .8600546667768981700419079d-1,
     :  .8214762533231104047151097d-1,
     :  .7856473513008974607178765d-1,
     :  .7523246995193424459351750d-1,
     :  .7212848493340500348466924d-1,
     :  .6923238018945846374255513d-1,
     :  .6652562400245432725286132d-1,
     :  .6399144848312167544450556d-1,
     :  .6161472819590847810012464d-1,
     :  .5938184999317344054777048d-1,
     :  .5728058034957269600588669d-1,
     :  .5529993483145627029203620d-1,
     :  .5343005296426139233134751d-1,
     :  .5166208065197234887486323d-1,
     :  .4998806142885727821214551d-1,
     :  .4840083715410895783485349d-1,
     :  .4689395826338997495993764d-1,
     :  .4546160333748704598916335d-1,
     :  .4409850750954268216573793d-1,
     :  .4279989908392569899980027d-1,
     :  .4156144366035708515282858d-1,
     :  .4037919502845779134315796d-1,
     :  .3924955210570969222557380d-1,
     :  .3816922122416471946490538d-1,
     :  .3713518311895684989765586d-1,
     :  .3614466402785612590311943d-1,
     :  .3519511037069617482332004d-1,
     :  .3428416653694949866994660d-1,
     :  .3340965536664229903158673d-1,
     :  .3256956096272257612903376d-1,
     :  .3176201352112533673779090d-1,
     :  .3098527590780517228496903d-1,
     :  .3023773174995156695256252d-1,
     :  .2951787484170619418302355d-1,
     :  .2882429969333463230632146d-1,
     :  .2815569307740452259166926d-1,
     :  .2751082644654734935368337d-1,
     :  .2688854911528297388431485d-1,
     :  .2628778211358937241904422d-1,
     :  .2570751263279204975253415d-1,
     :  .2514678899527364475073049d-1,
     :  .2460471608876676259183765d-1,
     :  .2408045121385331090696902d-1,
     :  .2357320029997478838776359d-1,
     :  .2308221445094914570064896d-1,
     :  .2260678678585010840991674d-1,
     :  .2214624954526743636682309d-1,
     :  .2169997143654264861646818d-1,
     :  .2126735519465680897241377d-1,
     :  .2084783533811200664569883d-1,
     :  .2044087610146017752978434d-1,
     :  .2004596952814515567227767d-1,
     :  .1966263370908071277476715d-1,
     :  .1929041115392591487587378d-1,
     :  .1892886728337045173071115d-1,
     :  .1857758903193275942486415d-1,
     :  .1823618355182474294515453d-1,
     :  .1790427700936730343669473d-1,
     :  .1758151346626646308038721d-1,
     :  .1726755383879409857500321d-1,
     :  .1696207492857163038741910d-1,
     :  .1666476851923932358834102d-1,
     :  .1637534053381661837450139d-1,
     :  .1609351024802744708797459d-1,
     :  .1581900955528515170398058d-1,
     :  .1555158227940989996039230d-1,
     :  .1529098353149220739767610d-1,
     :  .1503697910762349625920090d-1,
     :  .1478934492449222808347731d-1,
     :  .1454786649009525295887101d-1,
     :  .1431233840704145462214254d-1,
     :  .1408256390613103046576229d-1,
     :  .1385835440808103075999097d-1,
     :  .1363952911143803959964144d-1,
     :  .1342591460487383719630737d-1,
     :  .1321734450220107129175951d-1,
     :  .1301365909857474699723209d-1,
     :  .1281470504646293252049926d-1,
     :  .1262033505007755515762735d-1,
     :  .1243040757705449418533892d-1,
     :  .1224478658626222948827240d-1,
     :  .1206334127070085131071308d-1,
     :  .1188594581452897199141430d-1,
     :  .1171247916332562864755594d-1,
     :  .1154282480675818732553606d-1,
     :  .1137687057288605896976939d-1,
     :  .1121450843338417065773542d-1,
     :  .1105563431902001242285305d-1,
     :  .1090014794476407143162512d-1,
     :  .1074795264395590657657700d-1,
     :  .1059895521098731117021612d-1,
     :  .1045306575200023435008377d-1,
     :  .1031019754313063242129945d-1,
     :  .1017026689586042607609242d-1,
     :  .1003319302906845397201302d-1,
     :  .9898897947397924639729408d-2,
     :  .9767306325582547468180475d-2,
     :  .9638345398396424782187982d-2,
     :  .9511944855914052317394595d-2,
     :  .9388036743786533882143785d-2,
     :  .9266555368258485665416943d-2,
     :  .9147437205667194364984339d-2,
     :  .9030620816181499749829423d-2,
     :  .8916046761552686783940876d-2,
     :  .8803657526663477808232965d-2,
     :  .8693397444674087410976982d-2,
     :  .8585212625576311168220303d-2,
     :  .8479050887977828363904268d-2,
     :  .8374861693949366877024963d-2,
     :  .8272596086777159693185345d-2,
     :  .8172206631472266686907249d-2,
     :  .8073647357896888215194357d-2,
     :  .7976873706375800846399120d-2,
     :  .7881842475668539112571351d-2,
     :  .7788511773184966394916599d-2,
     :  .7696840967333456047851643d-2,
     :  .7606790641897071224649652d-2,
     :  .7518322552338916854888971d-2,
     :  .7431399583943265980411531d-2,
     :  .7345985711704159367477213d-2,
     :  .7262045961877964368036759d-2,
     :  .7179546375120877141317720d-2,
     :  .7098453971136580788416864d-2,
     :  .7018736714763248519923831d-2,
     :  .6940363483432822204243367d-2,
     :  .6863304035939017881037086d-2,
     :  .6787528982453825324020280d-2,
     :  .6713009755735391745310971d-2,
     :  .6639718583473122562606414d-2,
     :  .6567628461718606252976457d-2,
     :  .6496713129353586350126915d-2,
     :  .6426947043548671526978323d-2,
     :  .6358305356168803683625031d-2,
     :  .6290763891083702643557758d-2,
     :  .6224299122343582476647260d-2,
     :  .6158888153182396103862750d-2,
     :  .6094508695812718682782931d-2,
     :  .6031139051978132847456608d-2,
     :  .5968758094230636272231571d-2,
     :  .5907345247902159938278185d-2,
     :  .5846880473740769223255677d-2,
     :  .5787344251183524483318654d-2,
     :  .5728717562239307805652498d-2,
     :  .5670981875956182433959706d-2/

      data h2/
     :  1.0d0,
     :  .9925156067854728234166954d0,
     :  .9702488370741846925024279d0,
     :  .9337524315196362275518164d0,
     :  .8839262840201373526840738d0,
     :  .8219864299617913128547470d0,
     :  .7494235719224071131328299d0,
     :  .6679529582323300874171809d0,
     :  .5794577764970237101503160d0,
     :  .4859284571458759498915146d0,
     :  .3894003915357024341225852d0,
     :  .2918925528622829754342991d0,
     :  .1953493712998886960185562d0,
     :  .1015879694206602794774387d0,
     :  .1225252788368832137977160d-1,
     :  -.7122285309136537622082871d-1,
     :  -.1476418787320535960282345d0,
     :  -.2160639183435653507962620d0,
     :  -.2758120010582235033784961d0,
     :  -.3264713765759730440736642d0,
     :  -.3678794411714423215955238d0,
     :  -.4001081341403160736400280d0,
     :  -.4234401367904400766628734d0,
     :  -.4383403499032471637408907d0,
     :  -.4454241863223889026399290d0,
     :  -.4454241976960828728637340d0,
     :  -.4391564671033144569589568d0,
     :  -.4274880540708223266513326d0,
     :  -.4113065890894513887520768d0,
     :  -.3914928958756679769706131d0,
     :  -.3688972859665251787412620d0,
     :  -.3443199355303629399446828d0,
     :  -.3184955306263949534807185d0,
     :  -.2920821644962502188874669d0,
     :  -.2656542962828890681640534d0,
     :  -.2396994397177897912204020d0,
     :  -.2146181451424491640939456d0,
     :  -.1907267687784773058932939d0,
     :  -.1682624875086995569546816d0,
     :  -.1473900121018631148986771d0,
     :  -.1282094722211392620560261d0,
     :  -.1107649874577763082733483d0,
     :  -.9505349453993480902150559d-1,
     :  -.8103346641770551054241192d-1,
     :  -.6863322916783106348475741d-1,
     :  -.5775865327580743751389419d-1,
     :  -.4830006328783957980109026d-1,
     :  -.4013827136320013258889535d-1,
     :  -.3314969401563551466825700d-1,
     :  -.2721055620979549646261829d-1,
     :  -.2220022256661865628545539d-1,
     :  -.1800372189840480267502263d-1,
     :  -.1451354925728548119815172d-1,
     :  -.1163084007733763911929080d-1,
     :  -.9266014956431594449373699d-2,
     :  -.7338992385437093554928018d-2,
     :  -.5779061516816548137194317d-2,
     :  -.4524499030007499171731476d-2,
     :  -.3522004336456824141111923d-2,
     :  -.2726016661692386541868837d-2,
     :  -.2097966669473552341459824d-2,
     :  -.1605504811757694087682580d-2,
     :  -.1221738898797218035679319d-2,
     :  -.9245047462622340271825711d-3,
     :  -.6956863110190540254524861d-3,
     :  -.5205955169809141905659767d-3,
     :  -.3874169656489197360292113d-3,
     :  -.2867188376814953929994613d-3,
     :  -.2110284027525126746959732d-3,
     :  -.1544685271976339753833504d-3,
     :  -.1124502587150317136058296d-3,
     :  -.8141583451940456365639560d-4,
     :  -.5862617398424354123250055d-4,
     :  -.4198696356554642675724513d-4,
     :  -.2990772192017133390000897d-4,
     :  -.2118866502002593128272052d-4,
     :  -.1493070967418717996705171d-4,
     :  -.1046450930688891587354327d-4,
     :  -.7294971485088477169986746d-5,
     :  -.5058237141326785665552064d-5,
     :  -.3488590416297032549927031d-5,
     :  -.2393206427093938070506012d-5,
     :  -.1633028318374209170743394d-5,
     :  -.1108394815502115127316820d-5,
     :  -.7483179321690142728739359d-6,
     :  -.5025418723896900527555212d-6,
     :  -.3357037469306895805115546d-6,
     :  -.2230700306981556484079346d-6,
     :  -.1474451577404705893471723d-6,
     :  -.9694537142843821183145493d-7,
     :  -.6340650817983165854183039d-7,
     :  -.4125281597997292543454039d-7,
     :  -.2669863608647444234432417d-7,
     :  -.1718869397329539903528673d-7,
     :  -.1100823095953252158935162d-7,
     :  -.7013187829205346730804204d-8,
     :  -.4444665113656971914920979d-8,
     :  -.2802144497835918309456751d-8,
     :  -.1757406038399392007880848d-8,
     :  -.1096442676719878283524089d-8,
     :  -.6805092493832370091384262d-9,
     :  -.4201635819811978308984480d-9,
     :  -.2580720549398903308510481d-9,
     :  -.1576898051707325645824557d-9,
     :  -.9585353270320148521118371d-10,
     :  -.5796372027032496381736661d-10,
     :  -.3486981951439767325186431d-10,
     :  -.2086844614201629359434107d-10,
     :  -.1242450483517188985330601d-10,
     :  -.7358989436838238028175315d-11,
     :  -.4336195837012716989509190d-11,
     :  -.2541866144559293225048769d-11,
     :  -.1482350707216456169596291d-11,
     :  -.8600132295160969048704279d-12,
     :  -.4963825648030345884941720d-12,
     :  -.2850272799994640993351100d-12,
     :  -.1628231410435433343915847d-12,
     :  -.9253517530796568988711767d-13,
     :  -.5231904387078439423734991d-13,
     :  -.2942904274907536637035087d-13,
     :  -.1646861209472934265701707d-13,
     :  -.9168609972068950589419375d-14,
     :  -.5078280768842531755862938d-14,
     :  -.2798321959684086361623925d-14,
     :  -.1534077985990025530178263d-14,
     :  -.8366946223931157801875458d-15,
     :  -.4540014839572489640421670d-15,
     :  -.2450864324006565520585709d-15,
     :  -.1316297011679965318337360d-15,
     :  -.7033347094398993022030766d-16,
     :  -.3738906588834781501200156d-16,
     :  -.1977436055729519304364136d-16,
     :  -.1040486355537857239908506d-16,
     :  -.5446873085247993592442947d-17,
     :  -.2836846572016980047452363d-17,
     :  -.1469951297806504842876013d-17,
     :  -.7577907726628295065637298d-18,
     :  -.3886652327556223671914838d-18,
     :  -.1983274447591697794634031d-18,
     :  -.1006865346010664339728430d-18,
     :  -.5085599093462560019056651d-19,
     :  -.2555616473221360979839205d-19,
     :  -.1277711291477349028381922d-19,
     :  -.6355561617974547678564100d-20,
     :  -.3145284379748115775839534d-20,
     :  -.1548642984144385532194339d-20,
     :  -.7586277364385535380007560d-21,
     :  -.3697368508385495481212434d-21,
     :  -.1792850002167444277197814d-21,
     :  -.8649339487208141711410640d-22,
     :  -.4151549880751819128657313d-22,
     :  -.1982560526365887292005855d-22,
     :  -.9419591402219956768405243d-23,
     :  -.4452742857507067242031201d-23,
     :  -.2094178149147388017585982d-23,
     :  -.9799199383965174477667876d-24,
     :  -.4562039303075778937781093d-24,
     :  -.2113096807073358619927786d-24,
     :  -.9738054125666016460529380d-25,
     :  -.4464962955517461045769742d-25,
     :  -.2036839830996770073279630d-25,
     :  -.9244633325579509781433326d-26,
     :  -.4174617922924968276183391d-26,
     :  -.1875592296561359766067593d-26,
     :  -.8384076547424474404764890d-27,
     :  -.3728786627489159285725893d-27,
     :  -.1649968834419055881014869d-27,
     :  -.7264074023243377877657008d-28,
     :  -.3181863066343386789136187d-28,
     :  -.1386691329625598948075213d-28,
     :  -.6012783734099460236172624d-29,
     :  -.2593995437123362612886143d-29,
     :  -.1113425178718492778355866d-29,
     :  -.4755009983792073461050496d-30,
     :  -.2020415749389589696795519d-30,
     :  -.8541405110545145479519840d-31,
     :  -.3592671419230207088768861d-31,
     :  -.1503507555679300913224246d-31,
     :  -.6260283436716785719346509d-32,
     :  -.2593480377514370417261009d-32,
     :  -.1068988029132498238513063d-32,
     :  -.4383933266292682172809914d-33,
     :  -.1788778436796033153181937d-33,
     :  -.7261912176216306101089190d-34,
     :  -.2933239704874698217172402d-34,
     :  -.1178817380216022663848294d-34,
     :  -.4713550938665925243747415d-35,
     :  -.1875222736937308593811831d-35,
     :  -.7422680608185535408905020d-36,
     :  -.2923292133270549875473422d-36,
     :  -.1145479868926911875642964d-36,
     :  -.4465877102072613609496200d-37,
     :  -.1732329082290364039482100d-37,
     :  -.6685880402092324407358875d-38,
     :  -.2567388790315000103954881d-38,
     :  -.9809113395522088573556313d-39,
     :  -.3728835208268407801110216d-39,
     :  -.1410334685901388337197457d-39,
     :  -.5307340860010760817486761d-40,
     :  -.1987182729569070557023125d-40,
     :  -.7402951192281463566289795d-41,
     :  -.2743964271316156357722060d-41/

      data h3/
     :  -.7522527780636750492641059d0,
     :  -.7447490315497708463240858d0,
     :  -.7224619689626252165385118d0,
     :  -.6860552061846493969863268d0,
     :  -.6366054955061156295204758d0,
     :  -.5755603365344096850483262d0,
     :  -.5046815829547811446478382d0,
     :  -.4259777864640005624125117d0,
     :  -.3416285184773921405216660d0,
     :  -.2539042236274465364534081d0,
     :  -.1650852727968867264939651d0,
     :  -.7738379667939842709258988d-1,
     :  .7128394424195324853014844d-2,
     :  .8658293927736663174097951d-1,
     :  .1593668102410841966827594d0,
     :  .2241613263920280449352809d0,
     :  .2799673824845877680517527d0,
     :  .3261167006652041288605015d0,
     :  .3622695948610319801705815d0,
     :  .3884003473857446343896496d0,
     :  .4047718038942624860766923d0,
     :  .4119011753186058824533937d0,
     :  .4105192820995319949018743d0,
     :  .4015255845130582620257648d0,
     :  .3859413195031716183649201d0,
     :  .3648629230000597762360636d0,
     :  .3394176769351978836202936d0,
     :  .3107232057693364099667621d0,
     :  .2798520840662402744643034d0,
     :  .2478024303401173430156194d0,
     :  .2154749773684402246897790d0,
     :  .1836567467116494732079552d0,
     :  .1530111326375332319918793d0,
     :  .1240739307148443832620940d0,
     :  .9725463688468146271051371d-1,
     :  .7284219701173870412977577d-1,
     :  .5101430368585303674221369d-1,
     :  .3184931174142700893159512d-1,
     :  .1533986919450959655382290d-1,
     :  .1407426811309193306581366d-2,
     :  -.1008311291608286074413380d-1,
     :  -.1930922840812282398312132d-1,
     :  -.2647758532035030682089135d-1,
     :  -.3181217775839225922486926d-1,
     :  -.3554404023046894464526427d-1,
     :  -.3790265208183702749516685d-1,
     :  -.3910905737306063850349279d-1,
     :  -.3937064210715186736633504d-1,
     :  -.3887744829978686271653342d-1,
     :  -.3779986028416367095012508d-1,
     :  -.3628747152011772566083547d-1,
     :  -.3446892799961155950489723d-1,
     :  -.3245254463375208029954651d-1,
     :  -.3032750110251363953076864d-1,
     :  -.2816544089164076874994184d-1,
     :  -.2602231914851994604543481d-1,
     :  -.2394036936359898584929537d-1,
     :  -.2195008388641825247433045d-1,
     :  -.2007212746338689903391700d-1,
     :  -.1831912527214265469865516d-1,
     :  -.1669728661861120572688442d-1,
     :  -.1520784216814043766189564d-1,
     :  -.1384828617477219420839203d-1,
     :  -.1261342573197174928239427d-1,
     :  -.1149624682246302216128454d-1,
     :  -.1048861222035593117850278d-1,
     :  -.9581809474549548274726564d-2,
     :  -.8766968673914992518412266d-2,
     :  -.8035369845963356580758239d-2,
     :  -.7378659024311709843220737d-2,
     :  -.6788990545369120409265684d-2,
     :  -.6259111260511144290061333d-2,
     :  -.5782400284632080908741386d-2,
     :  -.5352875804464578036313191d-2,
     :  -.4965178455311671875710459d-2,
     :  -.4614538919616485527188256d-2,
     :  -.4296735750484013517713710d-2,
     :  -.4008047998562558651176877d-2,
     :  -.3745206023826233664801882d-2,
     :  -.3505342894046476979204381d-2,
     :  -.3285947990022833548498951d-2,
     :  -.3084823830238963251792028d-2,
     :  -.2900046668982056656687612d-2,
     :  -.2729931086807768375811907d-2,
     :  -.2572998556853316466871207d-2,
     :  -.2427949813646523181953355d-2,
     :  -.2293640754330915732383722d-2,
     :  -.2169061550185197106672818d-2,
     :  -.2053318626361484792588433d-2,
     :  -.1945619169898585865047079d-2,
     :  -.1845257842557062274985012d-2,
     :  -.1751605400071271234291063d-2,
     :  -.1664098948801722796139379d-2,
     :  -.1582233601544145935191528d-2,
     :  -.1505555324435757496173641d-2,
     :  -.1433654795260900326865144d-2,
     :  -.1366162119305863305428748d-2,
     :  -.1302742271937752484738341d-2,
     :  -.1243091157235637593921277d-2,
     :  -.1186932189400779713774489d-2,
     :  -.1134013318531012910469058d-2,
     :  -.1084104434925714219487149d-2,
     :  -.1036995096671516116549004d-2,
     :  -.9924925341187004927105684d-3,
     :  -.9504198922493585737226438d-3,
     :  -.9106146780909950790852145d-3,
     :  -.8729273854455090856168734d-3,
     :  -.8372202734577421999252958d-3,
     :  -.8033662790881490171689315d-3,
     :  -.7712480465049772662387464d-3,
     :  -.7407570588761368843162862d-3,
     :  -.7117928601052224681383490d-3,
     :  -.6842623557902678206459998d-3,
     :  -.6580791841453911032352388d-3,
     :  -.6331631488616646148452257d-3,
     :  -.6094397069328185150662371d-3,
     :  -.5868395053652243037188589d-3,
     :  -.5652979614557357816469240d-3,
     :  -.5447548819764808379193485d-3,
     :  -.5251541171699206704315699d-3,
     :  -.5064432459446979814905582d-3,
     :  -.4885732890847829717111949d-3,
     :  -.4714984476509869340551945d-3,
     :  -.4551758640732029088500233d-3,
     :  -.4395654037105695480727411d-3,
     :  -.4246294549008608587718018d-3,
     :  -.4103327457346023732872108d-3,
     :  -.3966421759777806984761265d-3,
     :  -.3835266627330082944382909d-3,
     :  -.3709569985755748701109446d-3,
     :  -.3589057210304776810509891d-3,
     :  -.3473469923714317173865229d-3,
     :  -.3362564888248703524021643d-3,
     :  -.3256112983526542094353014d-3,
     :  -.3153898262679901745636708d-3,
     :  -.3055717080111181576022737d-3,
     :  -.2961377284756872027881530d-3,
     :  -.2870697473343167903391904d-3,
     :  -.2783506298634098374691914d-3,
     :  -.2699641828135376810549337d-3,
     :  -.2618950949132550960609061d-3,
     :  -.2541288816315519571599965d-3,
     :  -.2466518338577700959600751d-3,
     :  -.2394509701881161861915701d-3,
     :  -.2325139925352426415436720d-3,
     :  -.2258292448020649292499711d-3,
     :  -.2193856743833149971866920d-3,
     :  -.2131727962785441468085678d-3,
     :  -.2071806596186039850962257d-3,
     :  -.2013998164242456949121338d-3,
     :  -.1958212924305587453675523d-3,
     :  -.1904365598246742268269672d-3,
     :  -.1852375117566223449189077d-3,
     :  -.1802164384945805472907308d-3,
     :  -.1753660051060874920343825d-3,
     :  -.1706792305562262391906103d-3,
     :  -.1661494681223850440721571d-3,
     :  -.1617703870330642541013594d-3,
     :  -.1575359552453832883093564d-3,
     :  -.1534404232825155716084045d-3,
     :  -.1494783090582982775062280d-3,
     :  -.1456443836217787948749789d-3,
     :  -.1419336577595168918308957d-3,
     :  -.1383413693981019940302776d-3,
     :  -.1348629717536061671270311d-3,
     :  -.1314941221786090162018978d-3,
     :  -.1282306716610312631043834d-3,
     :  -.1250686549323268134999138d-3,
     :  -.1220042811456336331711188d-3,
     :  -.1190339250872943430156140d-3,
     :  -.1161541188877486230913414d-3,
     :  -.1133615442001899065679247d-3,
     :  -.1106530248175853517419676d-3,
     :  -.1080255197006960803598953d-3,
     :  -.1054761163916181391183883d-3,
     :  -.1030020247891063146774180d-3,
     :  -.1006005712635544029343839d-3,
     :  -.9826919309099737327798045d-4,
     :  -.9600543318688272806740460d-4,
     :  -.9380693512163903486436983d-4,
     :  -.9167143840125715403094134d-4,
     :  -.8959677399720145006388879d-4,
     :  -.8758086011099098595144745d-4,
     :  -.8562169815974051700802759d-4,
     :  -.8371736896983366064768422d-4,
     :  -.8186602916672109476829247d-4,
     :  -.8006590774959976520266573d-4,
     :  -.7831530284043921555152064d-4,
     :  -.7661257859748228262605498d-4,
     :  -.7495616228396319961002592d-4,
     :  -.7334454148335998246272097d-4,
     :  -.7177626145303295708079228d-4,
     :  -.7024992260860025649833230d-4,
     :  -.6876417813186671874001603d-4,
     :  -.6731773169555726054493046d-4,
     :  -.6590933529851172806481185d-4,
     :  -.6453778720537748581672358d-4,
     :  -.6320192998519050404738797d-4,
     :  -.6190064864356719221383246d-4,
     :  -.6063286884353932444622322d-4,
     :  -.5939755521035460581086281d-4,
     :  -.5819370971583712468698264d-4/

*
      v=vin
c     Voigt function is symmetric, so -v = v
      if (v.lt.0.0d0) v = -v
c     if a is exactly zero go to 3 for exact expression
      if (a.eq.0.d0) goto 3
c     Scale up v for ease with lookup tables
      v0 = v*10.d0
      n = int(v0)
c     If u < 10, go to 1. Otherwise use asymptotic expression.
      if (n.lt.100) goto 1
      r=1/(v*v)
      voigt=a*r*oneonsqrtpi*(1.d0 + r*(1.5d0 + r*(3.75d0 + 
     :     r*(13.125d0 + 59.0625d0*r))) - a*a*r*(
     :     1.d0 + r*(5.d0 +26.25d0*r)))
      return
c     Arrive here if v < 10
 1    v0 = 2*v*10.d0
c     Scale up v again by 2, then find closet integer. This gives
c     the index for the lookup table array.
      n = int(v0)
*      v1 = dble(n)
c     Add one to the integer value because Fortran arrays
c     are unit offset. Then find the next two array indices.
      p = n+1
      p1 = p+1
      p2 = p1+1
c     Calculate the abcissa values associated with each entry
c     in the lookup table.
      x=(dble(p)-1)*0.5d0
      y=x+0.5d0
      z=y+0.5d0
c     Now rescale v0 back by 1/2
      v0=0.5d0*v0
c     Use optimised Lagrange classical interpolation formula for
c     a quadratic. Interpolation is done three times, for h0, h1 and h2.
c     As the absicssa points are equally spaced the result has 
c     been factored further.
      voigt =
     : 2.d0*((v0-y)*(v0-z)*(h0(p)+a*(h1(p)+a*(h2(p)+a*h3(p))))
     : - (v0-x)*(v0-z)*2.d0*(h0(p1) + 
     :     a*(h1(p1)+a*(h2(p1)+a*h3(p1))))
     : + (v0-x)*(v0-y)*(h0(p2) + 
     :     a*(h1(p2)+a*(h2(p2)+a*h3(p2)))))
      return
 3    voigt = dexp(-(v*v))   
      return
      end
