      SUBROUTINE NBINT(I,IKS)
*
*
*       N-body integration.
*       -------------------
*
      INCLUDE 'commonp.h'
      PARAMETER  (ONE24=1.0/24.0D0)
      REAL*8  XI(3),XIDOT(3),FIRR(3),FD(3),DV(3),FIN(3),FDN(3),
     &        AT3(3),BT2(3),XP(3),VP(3)
      SAVE IPLOT
      DATA IPLOT /0/
*
*
*       Check regularization criterion for single particles.
      IF (STEP(I).LT.DTMIN.AND.I.LE.N.AND.IFIRST.EQ.1) THEN
*       See whether dominant body can be regularized.
          IF (IKS.EQ.0) THEN
              CALL SEARCH(I,IKS)
          END IF
      END IF
*
*       Form time-step factors and update T0.
      DT = TIME - T0(I)
      DTSQ = DT**2
      DT2 = 2.0/DTSQ
      DT6 = 6.0/(DT*DTSQ)
      DT12 = ONE12*DT
      DTSQ12 = ONE12*DTSQ
      DT13 = ONE3*DT
      T0(I) = TIME
*
      DT3 = DT*DTSQ
      DT4 = ONE24*DT3*DT
      DT3 = ONE6*DT3
      DT025 = 0.25*DT
      DT02 = 0.2*DT
*
*       Save X & XDOT and predict to high order for increased accuracy.
      DO 5 K = 1,3
          XP(K) = X(K,I)
          VP(K) = XDOT(K,I)
          XI(K) = XP(K) + (D3(K,I)*DT02 + D2(K,I))*DT4
          XIDOT(K) = VP(K) + (D3(K,I)*DT025 + D2(K,I))*DT3
          FIRR(K) = 0.0D0
          FD(K) = 0.0D0
    5 CONTINUE
*
*       Treat c.m. body more carefully.
      IF (I.GT.N) THEN
          CALL CMF(XI,XIDOT,FIRR,FD)
          GO TO 40
      END IF
*
*       Obtain force & derivative from non-zero mass particles.
      DO 10 J = IFIRST,NMASS
          IF (J.EQ.I) GO TO 10
          A1 = X(1,J) - XI(1)
          A2 = X(2,J) - XI(2)
          A3 = X(3,J) - XI(3)
          DV(1) = XDOT(1,J) - XIDOT(1)
          DV(2) = XDOT(2,J) - XIDOT(2)
          DV(3) = XDOT(3,J) - XIDOT(3)
          RIJ2 = A1*A1 + A2*A2 + A3*A3
*
          DR2I = 1.0/RIJ2
          DR3I = BODY(J)*DR2I*SQRT(DR2I)
          DRDV = 3.0*(A1*DV(1) + A2*DV(2) + A3*DV(3))*DR2I
*
          FIRR(1) = FIRR(1) + A1*DR3I
          FIRR(2) = FIRR(2) + A2*DR3I
          FIRR(3) = FIRR(3) + A3*DR3I
          FD(1) = FD(1) + (DV(1) - A1*DRDV)*DR3I
          FD(2) = FD(2) + (DV(2) - A2*DRDV)*DR3I
          FD(3) = FD(3) + (DV(3) - A3*DRDV)*DR3I
   10 CONTINUE
*
*       Include possible regularized c.m. or components.
      IF (IFIRST.EQ.1) GO TO 40
          J = NTOT
          A1 = X(1,J) - XI(1)
          A2 = X(2,J) - XI(2)
          A3 = X(3,J) - XI(3)
          DV(1) = XDOT(1,J) - XIDOT(1)
          DV(2) = XDOT(2,J) - XIDOT(2)
          DV(3) = XDOT(3,J) - XIDOT(3)
          RIJ2 = A1*A1 + A2*A2 + A3*A3
*       Check the c.m. approximation.
          R2 = R(1)**2 + R(2)**2 + R(3)**2
          IF (RIJ2.GT.CMSEP2*R2.OR.LIST(1).EQ.0) GO TO 30
          CALL RESOLV
          J = 1
   20     A1 = X(1,J) - XI(1)
          A2 = X(2,J) - XI(2)
          A3 = X(3,J) - XI(3)
          DV(1) = XDOT(1,J) - XIDOT(1)
          DV(2) = XDOT(2,J) - XIDOT(2)
          DV(3) = XDOT(3,J) - XIDOT(3)
          RIJ2 = A1*A1 + A2*A2 + A3*A3
   30     DR2I = 1.0/RIJ2
          DR3I = BODY(J)*DR2I*SQRT(DR2I)
          DRDV = 3.0*(A1*DV(1) + A2*DV(2) + A3*DV(3))*DR2I
*
          FIRR(1) = FIRR(1) + A1*DR3I
          FIRR(2) = FIRR(2) + A2*DR3I
          FIRR(3) = FIRR(3) + A3*DR3I
          FD(1) = FD(1) + (DV(1) - A1*DRDV)*DR3I
          FD(2) = FD(2) + (DV(2) - A2*DRDV)*DR3I
          FD(3) = FD(3) + (DV(3) - A3*DRDV)*DR3I
          IF (J.EQ.1) THEN
              J = J + 1
              GO TO 20
          END IF
*
*       Include the corrector.
   40 DO 45 K = 1,3
	  DF = 2.0*F(K,I) - FIRR(K)
	  FID = 6.0*FDOT(K,I)
	  SUM = FID + FD(K)
	  AT3(K) = 2.0D0*DF + DT*SUM
	  BT2(K) = -3.0D0*DF - DT*(SUM + FID)
*
          X0(K,I) = XP(K) + (0.6*AT3(K) + BT2(K))*DTSQ12
          X0DOT(K,I) = VP(K) + (0.75*AT3(K) + BT2(K))*DT13
   45     CONTINUE
*
*       Set new F, FDOT, D2 & D3.
      DO 60 K = 1,3
	  F(K,I) = 0.5*FIRR(K)
	  FDOT(K,I) = ONE6*FD(K)
          D3(K,I) = AT3(K)*DT6
          D2(K,I) = (3.0*AT3(K) + BT2(K))*DT2
*       NOTE: These are real derivatives!
   60 CONTINUE
*
*       Specify new time-step (standard criterion or fast expression).
      IF (KZ(5).EQ.0) THEN
          TTMP = TSTEP(FIRR,FD,D2(1,I),D3(1,I),ETA)
      ELSE
          TTMP = STEPI(FIRR,FD,D2(1,I),D3(1,I),ETA)
      END IF
      DT0 = TTMP
*
*       Select discrete value (increased by 2, decreased by 2 or unchanged).
      IF (TTMP.GT.2.0*STEP(I)) THEN
          IF (DMOD(TIME,2.0*STEP(I)).EQ.0.0D0) THEN 
              TTMP = MIN(2.0*STEP(I),DTMAX)
          ELSE
              TTMP = STEP(I) 
          END IF
      ELSE IF (TTMP.LT.STEP(I)) THEN
          TTMP = 0.5*STEP(I)
*       Check for further reduction by factor 2.
          IF (TTMP.GT.DT0) THEN
              TTMP = 0.5*TTMP
          END IF
      ELSE
          TTMP = STEP(I)
      END IF
*
*       Set new block step and update next time.
      STEP(I) = TTMP
      TNEXT(I) = STEP(I) + T0(I)
*
*       See whether any KS candidates are in the same block as body #I.
      IF (IKS.GT.0.AND.I.EQ.ICOMP) THEN
*       Accept same time, otherwise reduce STEP(ICOMP) and/or delay.
          IF (T0(JCOMP).EQ.T0(ICOMP)) THEN
              ICOMP = MIN(ICOMP,JCOMP)
              JCOMP = MAX(I,JCOMP)
          ELSE IF (T0(JCOMP) + STEP(JCOMP).LT.T0(ICOMP)) THEN
              STEP(ICOMP) = 0.5D0*STEP(ICOMP)
              TNEXT(ICOMP) = STEP(ICOMP) + T0(ICOMP)
              IKS = 0
          ELSE
              IKS = 0
          END IF
      END IF
*
      RETURN
*
      END
