      SUBROUTINE CHTERM(ISUB)
*
*
*       Termination of chain system.
*       ----------------------------
*
      INCLUDE 'common3.h'
      PARAMETER  (NMX=10,NMX2=2*NMX,NMX3=3*NMX,NMX4=4*NMX,
     &            NMX8=8*NMX,NMXm=NMX*(NMX-1)/2)
      REAL*8  M,MASS,MC,MIJ,MKK,R2(NMX,NMX)
      INTEGER  IJ(NMX)
      COMMON/CHAIN1/  XCH(NMX3),VCH(NMX3),M(NMX),
     &                ZZ(NMX3),WC(NMX3),MC(NMX),
     &                XI(NMX3),PI(NMX3),MASS,RINV(NMXm),RSUM,MKK(NMX),
     &                MIJ(NMX,NMX),TKK(NMX),TK1(NMX),INAME(NMX),NN
      COMMON/CHAINC/  XC(3,NCMAX),BODYC(NCMAX),ICH,LISTC(100)
      COMMON/CHREG/  TIMEC,TMAX,RMAXC,CM(10),NAMEC(6),NSTEP1,KZ27,KZ30
      COMMON/CLUMP/   BODYS(NCMAX,5),T0S(5),TS(5),STEPS(5),RMAXS(5),
     &                NAMES(NCMAX,5),ISYS(5)
      COMMON/CCOLL2/  QK(NMX4),PK(NMX4),RIK(NMX,NMX),SIZE(NMX),VSTAR1,
     &                ECOLL1,RCOLL,QPERI,ISTAR(NMX),ICOLL,ISYNC,NDISS1
      COMMON/INCOND/  X4(3,NMX),XDOT4(3,NMX)
      COMMON/ECHAIN/  ECH
*
*
*       Decide between standard termination or collision (ISUB > 0 or < 0).
      IF (ISUB.NE.0) THEN
          ITERM = ISUB
          ISUB = IABS(ISUB)
      END IF
*
*       Prepare KS regularization and direct integration of two bodies.
      CALL R2SORT(IJ,R2)
      I1 = IJ(1)
      I2 = IJ(2)
      I3 = IJ(3)
      IF (NCH.EQ.2) I3 = I2
      IF (NCH.LE.3) THEN
          I4 = I3
          R2(I2,I4) = R2(I2,I3)
      ELSE
          I4 = IJ(4)
      END IF
*
      IF (KZ(30).GT.2) THEN
          WRITE (6,1)  SQRT(R2(I1,I2)), SQRT(R2(I1,I3)),SQRT(R2(I2,I3)),
     &                 SQRT(R2(I2,I4)), SQRT(R2(I3,I4))
    1     FORMAT (' CHTERM:   RIJ (1-2 1-3 2-3 2-4 3-4)  ',1P,5E9.1)
      END IF
*
      JLIST(5) = NAMEC(I1)
      JLIST(6) = NAMEC(I2)
      JLIST(7) = NAMEC(I3)
      JLIST(8) = NAMEC(I4)
*
*       Specify chain phase indicator and restore original name to c.m. body.
      IPHASE = 8
      NAME(ICH) = NAME0
*
*       Identify current global indices by searching all particles.
      DO 10 J = IFIRST,NTOT
          DO 5 L = 1,NCH
              IF (NAME(J).EQ.JLIST(L+4)) THEN
                  JLIST(L) = J
                  IF (BODY(J).GT.0.0D0) ICM = J
              END IF
    5     CONTINUE
   10 CONTINUE
*
*       Modify identification list for special cases NCH = 2 & NCH = 3.
      IF (NCH.EQ.2) THEN
          I3 = I1
          I4 = I2
          JLIST(3) = JLIST(1)
          JLIST(4) = JLIST(2)
      ELSE IF (NCH.EQ.3) THEN
          JLIST(4) = JLIST(3)
      END IF
*
*       Ensure ICOMP < JCOMP for KS regularization.
      ICOMP = MIN(JLIST(1),JLIST(2))
      JCOMP = MAX(JLIST(1),JLIST(2))
*
*       Copy final coordinates & velocities to standard variables.
      LK = 0
      DO 20 L = 1,NCH
          DO 15 K = 1,3
              LK = LK + 1
              X4(K,L) = XCH(LK)
              XDOT4(K,L) = VCH(LK)
   15     CONTINUE
   20 CONTINUE
*
*       Update the global time and delay output times to avoid troubles.
      TIME = T0S(ISUB) + TIMEC
      TADJ = MAX(TADJ,TIME)
      TNEXT = MAX(TNEXT,TIME)
*
*       Predict current coordinates & velocities to F3DOT before termination.
      CALL XVPRED(ICM,-1)
*
*       Copy c.m. coordinates & velocities.
      DO 30 K = 1,3
          CM(K) = X(K,ICM)
          CM(K+3) = XDOT(K,ICM)
   30 CONTINUE
*
*       Set configuration pointers for KS candidates & distant bodies.
      JLIST(5) = I1
      JLIST(6) = I2
      JLIST(7) = I3
      JLIST(8) = I4
*
*       Place new coordinates in the original locations.
      DO 40 L = 1,NCH
          J = JLIST(L)
*       Compare global name & subsystem name to restore the mass & T0.
          DO 32 K = 1,NCH
              IF (NAME(J).EQ.NAMEC(K)) THEN
                  BODY(J) = BODYC(K)
                  T0(J) = TIME
              END IF
   32     CONTINUE
*       Transform to global coordinates & velocities using c.m. values.
          LL = JLIST(L+4)
          DO 35 K = 1,3
              X(K,J) = X4(K,LL) + CM(K)
              XDOT(K,J) = XDOT4(K,LL) + CM(K+3)
              X0(K,J) = X(K,J)
              X0DOT(K,J) = XDOT(K,J)
   35     CONTINUE
   40 CONTINUE
*
*       Predict coordinates & velocities of perturbers to order FDOT.
      NNB = LISTC(1)
      DO 50 L = 2,NNB+1
          J = LISTC(L)
          CALL XVPRED(J,0)
*       Copy neighbours for splitting chain c.m. into components.
          JPERT(L-1) = J
*       Reduce time-step and check NLIST membership.
          STEP(J) = MAX(0.5D0*STEP(J),TIME - T0(J))
          IF (T0(J) + STEP(J).LT.TLIST) THEN
              CALL NLMOD(J,1)
          END IF
   50 CONTINUE
*
*       Update subsystem COMMON variables unless last or only case.
      IF (ISUB.LT.NSUB) THEN
          DO 60 L = ISUB,NSUB
              DO 55 K = 1,6
                  BODYS(K,L) = BODYS(K,L+1)
                  NAMES(K,L) = NAMES(K,L+1)
   55         CONTINUE
              T0S(L) = T0S(L+1)
              TS(L) = TS(L+1)
              STEPS(L) = STEPS(L+1)
              RMAXS(L) = RMAXS(L+1)
              ISYS(L) = ISYS(L+1)
   60     CONTINUE
      END IF
*
*       Check for stellar collision (only needs coordinates & velocities).
      IF (ITERM.LT.0) THEN
          JLIST(1) = ICOMP
          JLIST(2) = JCOMP
*
*       See whether re-labelling is required (indices I1 - I4 still local).
          IF (R2(I1,I4).LT.R2(I1,I3).OR.R2(I3,I4).LT.R2(I1,I3)) THEN
              IF (R2(I1,I4).LT.R2(I3,I4)) THEN
*       Switch body #I3 & I4 to give new dominant pair I1 & I3.
                  I = JLIST(4)
                  JLIST(4) = JLIST(3)
                  JLIST(3) = I
              ELSE
*       Set JLIST(5) < 0 to denote that body #I3 & I4 will be new KS pair.
                  JLIST(5) = -1
              END IF
          END IF
          DMINC = RCOLL
          GO TO 100
      END IF
*
*       Replace ICM in KS perturber lists by all subsystem members.
      CALL NBREST(ICM,NCH,NPAIRS)
*
*       Exclude the dominant interaction for c.m. approximation (large FDOT).
      IF (MIN(R2(I1,I3),R2(I2,I4)).GT.CMSEP2*R2(I1,I2)) THEN
          JLIST(1) = JLIST(3)
          JLIST(2) = JLIST(4)
          NNB = 2
          IF (NCH.EQ.3) JLIST(2) = JCLOSE
      ELSE
          NNB = NCH
      END IF
*
      IF (NCH.EQ.2) THEN
          JLIST(1) = JCLOSE
          NNB = 1
      END IF
*
*       Set dominant F & FDOT on body #ICOMP & JCOMP for #I3 & I4 in FPOLY2.
      CALL FCLOSE(ICOMP,NNB)
      CALL FCLOSE(JCOMP,NNB)
*
*       See whether a second binary is present (NCH = 4 & RB < RMIN).
      KS2 = 0
      IF (NCH.EQ.4.AND.R2(I3,I4).LT.RMIN2) THEN
*       Accept second KS pair if well separated (> 2) from smallest binary.
          IF (R2(I3,I4).LT.0.25*MIN(R2(I1,I3),R2(I2,I4))) THEN
              IF (MAX(JLIST(3),JLIST(4)).LE.N) THEN
                  KS2 = 1
              END IF
          END IF
      END IF
*
*       Specify global indices of least dominant bodies (I4 = I3 if NCH = 3).
      I3 = JLIST(3)
      I4 = JLIST(4)
*
*       Save global names of #I3 & I4 for initialization of second KS pair.
      IF (KS2.GT.0) THEN
          NAME3 = NAME(I3)
          NAME4 = NAME(I4)
      END IF
*
*       Initialize force polynomials & time-steps for body #I3 & #I4.
      IF (NCH.GT.2.AND.KS2.EQ.0) THEN
          CALL FPOLY1(I3,I3,0)
          IF (NCH.GE.4) THEN
              CALL FPOLY1(I4,I4,0)
              CALL FPOLY2(I4,I4,0)
          END IF
          CALL FPOLY2(I3,I3,0)
          STEP3 = STEP(I3)
          STEP4 = STEP(I4)
*
*       Check re-initialization of dormant super-hard binary (second pair).
          IF (MAX(I3,I4).GT.N) THEN
              I = MAX(I3,I4)
              CALL RENEW(I)
          END IF
*
*       See whether body #I3 or #I4 should be added to NLIST.
          I = I3
   70     IF (T0(I) + STEP(I).LT.TLIST) THEN
              CALL NLMOD(I,1)
          END IF
          IF (I.EQ.I3.AND.NCH.GE.4) THEN
              I = I4
              GO TO 70
          END IF
      END IF
*
*       Perform KS regularization of dominant components (ICOMP < JCOMP).
      IF (JCOMP.LE.N) THEN
          CALL KSREG
      ELSE
*       Initialize components separately and re-activate dormant binbary.
          CALL FPOLY1(JCOMP,JCOMP,0)
          CALL RENEW(JCOMP)
          CALL FPOLY1(ICOMP,ICOMP,0)
          CALL FPOLY2(ICOMP,ICOMP,0)
          CALL FPOLY2(JCOMP,JCOMP,0)
      END IF
*
      IF (KZ(30).GT.1) THEN
          WRITE (6,75)  TIME, I3, I4, NTOT, STEP3, STEP4, STEP(NTOT)
   75     FORMAT (' CHTERM:   T I3 I4 NT DT ',F9.4,3I4,1P,3E9.1)
      END IF
*
*       Initialize second KS pair if separation is small.
      IF (KS2.GT.0) THEN
          I3 = 0
*       Re-determine the global indices after updating in KSREG.
          DO 80 I = IFIRST,N
              IF (NAME(I).EQ.NAME3) I3 = I
              IF (NAME(I).EQ.NAME4) THEN
                  I4 = I
                  IF (I3.GT.0) GO TO 85
              END IF
   80     CONTINUE
*
*       Define components and perform new regularization.
   85     ICOMP = MIN(I3,I4)
          JCOMP = MAX(I3,I4)
          CALL KSREG
*
          IF (KZ(30).GT.1) THEN
              WRITE (6,90)  I3, I4, STEP(NTOT), STEP(2*NPAIRS-1),
     &                       R(NPAIRS), H(NPAIRS), GAMMA(NPAIRS)
   90         FORMAT (' CHTERM:   SECOND BINARY   I3 I4 DT DTK R H G ',
     &                                            2I4,1P,5E9.1)
          END IF
      END IF
*
*       Check minimum two-body distance.
      DMINC = MIN(DMINC,RCOLL)
*
*       Update net binary energy change.
      CHCOLL = CHCOLL + CM(9)
*
*       Update number of DIFSY calls, tidal dissipations & collision energy.
  100 NSTEPC = NSTEPC + NSTEP1
*     NDISS = NDISS + NDISS4
*     ECOLL = ECOLL + ECOLL3
*     E(10) = E(10) + ECOLL1
*
*       Reduce subsystem counter and initialize membership & internal energy.
      NSUB = NSUB - 1
      NCH = 0
      ECH = 0.0
*
*       Check for subsystem at last COMMON dump (no restart with NSUB > 0).
      IF (NSUB.EQ.0.AND.KZ(2).GE.1) THEN
          IF (TIME - TDUMP.LT.TIMEC) THEN
              TDUMP = TIME
              CALL MYDUMP(1,2)
          END IF
      END IF
*
*       Set phase indicator < 0 to ensure new NLIST in routine INTGRT.
      IPHASE = -1
*
      RETURN
*
      END
