      SUBROUTINE FCHAIN(I,XI,YI,ZI,FIRR)
*
*
*       Irregular force due to chain.
*       -----------------------------
*
      INCLUDE 'common3.h'
      COMMON/CHAINC/  XC(3,NCMAX),BODYC(NCMAX),ICH,LISTC(100)
      REAL*8  FIRR(3)
*
*
*       Subtract chain c.m. force from the current value (I =< N).
      A1 = X(1,ICH) - XI
      A2 = X(2,ICH) - YI
      A3 = X(3,ICH) - ZI
      RIJ2 = A1*A1 + A2*A2 + A3*A3
      A6 = BODY(ICH)/(RIJ2*SQRT(RIJ2))
      FIRR(1) = FIRR(1) - A1*A6
      FIRR(2) = FIRR(2) - A2*A6
      FIRR(3) = FIRR(3) - A3*A6
*
*       Resolve global coordinates in XC using the predicted c.m. position.
      CALL XCPRED(0)
*
*       Add force contributions from all members of the chain.
      DO 10 J = 1,NCH
          A1 = XC(1,J) - XI
          A2 = XC(2,J) - YI
          A3 = XC(3,J) - ZI
          RIJ2 = A1*A1 + A2*A2 + A3*A3
          A6 = BODYC(J)/(RIJ2*SQRT(RIJ2))
          FIRR(1) = FIRR(1) + A1*A6
          FIRR(2) = FIRR(2) + A2*A6
          FIRR(3) = FIRR(3) + A3*A6
   10 CONTINUE
*
      RETURN
*
      END
