      SUBROUTINE ASSESS(IPAIR,IM,ECC,SEMI,ITERM)
*
*
*       Assessment of hierarchical stability.
*       -------------------------------------
*
      INCLUDE 'common3.h'
      COMMON/BINARY/  CM(4,MMAX),XREL(3,MMAX),VREL(3,MMAX),
     &                HM(MMAX),UM(4,MMAX),UMDOT(4,MMAX),
     &                NAMEM(MMAX),NAMEG(MMAX)
      REAL*8  XX(3,3),VV(3,3)
      SAVE ITIME
      DATA ITIME /0/
*
*
*       Define indices for components and c.m.
      I1 = 2*IPAIR - 1
      I2 = I1 + 1
      ICM = N + IPAIR
*
*       Determine inclination between inner relative motion and outer orbit.
      RV = 0.0
      DO 10 K = 1,3
          XX(K,1) = XREL(K,IM)
          XX(K,2) = 0.0
          XX(K,3) = X(K,I2)
          VV(K,1) = VREL(K,IM)
          VV(K,2) = 0.0
          VV(K,3) = XDOT(K,I2)
          RV = RV + XREL(K,IM)*VREL(K,IM)
   10 CONTINUE
*
      CALL INCLIN(XX,VV,X(1,ICM),XDOT(1,ICM),ANGLE)
*
*       Form inner semi-major axis and eccentricity.
      RIN = SQRT(XREL(1,IM)**2 + XREL(2,IM)**2 + XREL(3,IM)**2)
      SEMI0 = -0.5*BODY(I1)/HM(IM)
      ECC2 = (1.0 - RIN/SEMI0)**2 + RV**2/(BODY(I1)*SEMI0)
      ECC0 = SQRT(ECC2)
      PMIN = SEMI*(1.0 - ECC)
      ITERM = 0
*
*       Evaluate the general stability function after perturbation effect.
      IF (ECC.LT.1.0) THEN
*       Obtain new stability boundary from Valtonen's criterion (MN 2017).
          QST = QSTAB(ECC0,ECC,ANGLE,CM(1,IM),CM(2,IM),BODY(I2))
*       Define termination by QSTAB.
          IF (QST*SEMI0.LT.PMIN) THEN
              ITERM = 0
          ELSE
              ITERM = 1
          END IF
      END IF
*
      RETURN
*
      END
