      SUBROUTINE CORE
*
*
*       Density centre & core radius.
*       -----------------------------
*
      INCLUDE 'common3.h'
      REAL*4  RLIST(NMAX),RHO,RHOS
      COMMON/WORK1/  RHO(NMAX)
*
*
*       Introduce N-dependent limit for small system.
      K = 1 + FLOAT(N)**0.33
      NBCRIT = MIN(K,6)
*       Set generous cutoff.
      RCORE2 = 4.0*RSCALE**2
      IF (TIME.GT.0.0D0) RCORE2 = MAX(16.0D0*RC**2,RCORE2)
*
*       Select > N/2 central particles. 
    5 NC = 0
      DO 10 I = IFIRST,NTOT
          RI2 = (X(1,I) - RDENS(1))**2 + (X(2,I) - RDENS(2))**2 +
     &                                   (X(3,I) - RDENS(3))**2
          IF (RI2.LT.RCORE2) THEN
              NC = NC + 1
              JLIST(NC) = I
          END IF
   10 CONTINUE
*
      IF (NC.LT.N/2) THEN
          RCORE2 = 1.5*RCORE2
          GO TO 5
      END IF
*
*       Obtain individual densities.
      RHOS = 0.0
      DO 50 L = 1,NC
          I = JLIST(L)
*       Estimate D6 to limit the candidates (reduce if N > 100).
          D6 = RCORE2
          XI = X(1,I)
          YI = X(2,I)
          ZI = X(3,I)
   20     N6 = 0
*
          DO 25 J = IFIRST,NTOT
              IF (J.EQ.I) GO TO 25
              RIJ2 = (XI - X(1,J))**2 + (YI - X(2,J))**2 +
     &                                  (ZI - X(3,J))**2
              IF (RIJ2.LT.D6) THEN
                  N6 = N6 + 1
                  RLIST(N6) = RIJ2
              END IF
   25     CONTINUE
*
          IF (N6.LE.NBCRIT) THEN
*       Make another iteration in rare cases.
              D6 = 1.5*D6
              IF (N6.LT.2) GO TO 20
          END IF
*
*       Sort list of square distances.
          DO 40 II = 1,N6
              DO 35 JJ = II+1,N6
                  IF (RLIST(JJ).LT.RLIST(II)) THEN
                      RDUM = RLIST(II)
                      RLIST(II) = RLIST(JJ)
                      RLIST(JJ) = RDUM
                  END IF
   35         CONTINUE
   40     CONTINUE
*
          I6 = MIN(N6,NBCRIT)
          RHO(I) = 1.0/(RLIST(I6)*SQRT(RLIST(I6)))
*       Assign zero weight if not enough neighbours.
          IF (N6.LT.NBCRIT) RHO(I) = 0.0D0
          RHOS = MAX(RHOS,RHO(I))
   50 CONTINUE
*
*       Determine density centre.
      DO 60 K = 1,3
          RDENS(K) = 0.0D0
   60 CONTINUE
      RHO1 = 0.0D0
      DO 70 L = 1,NC
          I = JLIST(L)
          DO 65 K = 1,3
              RDENS(K) = RDENS(K) + RHO(I)*X(K,I)
   65     CONTINUE
          RHO1 = RHO1 + RHO(I)
   70 CONTINUE
*
*       Set current density centre based on improved determination.
      DO 75 K = 1,3
          RDENS(K) = RDENS(K)/RHO1
   75 CONTINUE
*
*       Obtain density radius & averaged density.
      RC = 0.0D0
      RHO2 = 0.0D0
      DO 80 L = 1,NC
          I = JLIST(L)
          XID = X(1,I) - RDENS(1)
          YID = X(2,I) - RDENS(2)
          ZID = X(3,I) - RDENS(3)
          RID2 = XID**2 + YID**2 + ZID**2
          RC = RC + RHO(I)**2*RID2
          RHO2 = RHO2 + RHO(I)**2
   80 CONTINUE
*
*       Form core radius and average & maximum density (scaled in OUTPUT).
      RC = SQRT(RC/RHO2)
      RHOD = RHO2/RHO1
      RHOD = (15.0/12.566)*RHOD
      RHOM = (15.0/12.566)*RHOS
      IF (RC.EQ.0.0D0) THEN
          RC = RSCALE
          NC = N/2
      END IF
*
*       Sum particles & mass inside the core radius and set rms velocity.
      NC1 = 0
      VC = 0.0D0
      ZMC = 0.0D0
      RC2 = RC**2
      DO 85 L = 1,NC
          I = JLIST(L)
          XID = X(1,I) - RDENS(1)
          YID = X(2,I) - RDENS(2)
          ZID = X(3,I) - RDENS(3)
          RID2 = XID**2 + YID**2 + ZID**2
          IF (RID2.LT.RC2) THEN
              NC1 = NC1 + 1
              VC = VC + XDOT(1,I)**2 + XDOT(2,I)**2 + XDOT(3,I)**2
              ZMC = ZMC + BODY(I)
          END IF
   85 CONTINUE
*
*       Set core membership & rms velocity.
      NC = MAX(NC1,2)
      VC = SQRT(VC/FLOAT(NC))
*
      RETURN
*
      END
