      SUBROUTINE IMPACT(I)
*
*
*       Multiple collision or merger search.
*       ------------------------------------
*
      INCLUDE 'common3.h'
      REAL*8  XX(3,3),VV(3,3)
      CHARACTER*8  WHICH1
*
*
*       Set index of KS pair & first component of c.m. body #I.
      IPAIR = I - N
      I1 = 2*IPAIR - 1
      I2 = I1 + 1
      NCOUNT(21) = NCOUNT(21) + 1
      NTTRY = NTTRY + 1
      PERT1 = 0.0
      PERT2 = 0.0
      JCOMP = I
      NP = 0
*
*       Copy perturber list (> 4 members) or all particles.
      NNB2 = LIST(1,I1) + 1
      NP = 0
      IF (NNB2.GT.5) THEN
          DO 2 L = 2,NNB2
              J = LIST(L,I1)
              NP = NP + 1
              JLIST(NP) = J
    2     CONTINUE
      ELSE
          DO 4 J = IFIRST,NTOT
              IF (J.EQ.I) GO TO 4
              NP = NP + 1
              JLIST(NP) = J
    4     CONTINUE
      END IF
*
*       Find the dominant body (JCOMP) and nearest perturber (JMAX).
      DO 10 L = 1,NP
          J = JLIST(L)
          RIJ2 = (X(1,I) - X(1,J))**2 + (X(2,I) - X(2,J))**2 +
     &                                  (X(3,I) - X(3,J))**2
          PERT = BODY(J)/(RIJ2*SQRT(RIJ2))
          IF (PERT.GT.PERT2) THEN 
              IF (PERT.GT.PERT1) THEN
                  RJMIN2 = RIJ2
                  JMAX = JCOMP
                  JCOMP = J
                  PERT2 = PERT1
                  PERT1 = PERT
              ELSE
                  JMAX = J
                  PERT2 = PERT
              END IF
          END IF
   10 CONTINUE
*
      RDOT = (X(1,I) - X(1,JCOMP))*(X0DOT(1,I) - X0DOT(1,JCOMP)) +
     &       (X(2,I) - X(2,JCOMP))*(X0DOT(2,I) - X0DOT(2,JCOMP)) +
     &       (X(3,I) - X(3,JCOMP))*(X0DOT(3,I) - X0DOT(3,JCOMP))
*
*       Specify larger perturbation for optional chain regularization.
      IF (KZ(30).GT.0.AND.NCH.EQ.0) THEN
          GSTAR = 100.0*GMIN
          KCHAIN = 1
      ELSE
          GSTAR = GMIN
          KCHAIN = 0
      END IF
*
*       Only accept inward motion or small secondary perturbation.
      PERT3 = 2.0*R(IPAIR)**3*PERT2/BODY(I)
      IF (RDOT.GT.0.0.OR.PERT3.GT.100.0*GSTAR) GO TO 100
*
*       Skip rare case of merged binary (denoted by NAME < 0).
      IF (NAME(I).LT.0.OR.NAME(JCOMP).LT.0) GO TO 100
*
*       Include impact parameter test to distinguish different cases.
      A2 = (X0DOT(1,I) - X0DOT(1,JCOMP))**2 + 
     &     (X0DOT(2,I) - X0DOT(2,JCOMP))**2 +
     &     (X0DOT(3,I) - X0DOT(3,JCOMP))**2
      RIJ = SQRT(RJMIN2)
      A3 = 2.0/RIJ - A2/(BODY(I) + BODY(JCOMP))
      SEMI1 = 1.0/A3
      A4 = RDOT**2/(SEMI1*(BODY(I) + BODY(JCOMP)))
      ECC1 = SQRT((1.0D0 - RIJ/SEMI1)**2 + A4)
      PMIN = SEMI1*(1.0D0 - ECC1)
*
*       Set semi-major axis & eccentricity of inner binary.
      SEMI = -0.5D0*BODY(I)/H(IPAIR)
      SEMI0 = SEMI
      ECC2 = (1.0D0 - R(IPAIR)/SEMI)**2 + TDOT2(IPAIR)**2/(BODY(I)*SEMI)
      ECC = SQRT(ECC2)
*
*       Form binding energy of inner & outer binary.
      EB = BODY(2*IPAIR-1)*BODY(2*IPAIR)*H(IPAIR)/BODY(I)
      EB1 = -0.5*BODY(JCOMP)*BODY(I)/SEMI1
*
*       Obtain the total perturbing force acting on body #I & JCOMP.
      CALL FPERT(I,JCOMP,NP,PERT)
*
*       Choose maximum of dominant scalar & total vectorial perturbation.
      PERT = PERT*RJMIN2/(BODY(I) + BODY(JCOMP))
      PERT4 = 2.0*RJMIN2*RIJ*PERT2/(BODY(I) + BODY(JCOMP))
      PERTM = MAX(PERT4,PERT)
*
*       Use combined semi-major axis for binary-binary collision.
      IF (JCOMP.GT.N) THEN
          JPAIR = JCOMP - N
          SEMI2 = -0.5D0*BODY(JCOMP)/H(JPAIR)
          J1 = 2*JPAIR - 1
          EB2 = -0.5*BODY(J1)*BODY(J1+1)/SEMI2
*       Ensure SEMI0 is smallest binary in case IPAIR denotes widest pair.
          SEMI0 = MIN(ABS(SEMI),ABS(SEMI2))
          SEMI = SEMI + SEMI2
*       Do not allow negative or soft cross section.
          IF (1.0/SEMI.LT.1.0/RMIN) GO TO 100
*       Retain KS treatment for PMIN > SEMI and large semi-major axis ratio.
          IF (PMIN.GT.SEMI.AND.SEMI2.GT.20.0*SEMI0) GO TO 30
      END IF
*
*       Check separation in case of chain regularization.
      IF (KCHAIN.GT.9) THEN
*       Form effective gravitational radius (combine triple & quad).
          EBT = EB + EB1
          I1 = 2*IPAIR - 1
          ZMM = BODY(I1)*BODY(I1+1) + BODY(I)*BODY(JCOMP)
*       Set length of chain for decision-making (also used at termination).
          RSUM = R(IPAIR) + RIJ
          RI = R(IPAIR)
          IF (JCOMP.GT.N) THEN
              EBT = EBT + EB2
              ZMM = ZMM + BODY(J1)*BODY(J1+1)
              RSUM = RSUM + R(JPAIR)
              RI = MAX(R(JPAIR),RI)
          END IF
          RGRAV = ZMM/ABS(EBT)
          EBCH0 = EBT - EB1
*         WRITE (6,15)  I, JCOMP, SEMI0, SEMI1, RIJ, RSUM, RGRAV, EBT
*  15     FORMAT (' IMPACT:   I J A0 A1 RIJ RSUM RG EBT ',2I4,6F8.4)
          IF (RSUM.GT.MAX(3.0*RGRAV,RMIN).OR.RGRAV.GT.RMIN) GO TO 30
          GI = 2.0*BODY(JCOMP)*(RI/RIJ)**3/BODY(I)
*       Restrict maximum size to 0.01*RSCALE in case RMIN is large (small N).
          IF (GI.LT.0.05.OR.RSUM.GT.0.01*RSCALE) GO TO 30
          IF (KZ(27).GT.0.AND.JCOMP.GT.N) THEN
              IF (SEMI0.LT.SEMI2) J1 = I1
              RT = 4.0*MAX(RADIUS(J1),RADIUS(J1+1))
*       Do not allow large distance ratio for nearly synchronous binary.
              IF (SEMI0.GT.RT.AND.RI.GT.25.0*SEMI0) GO TO 30
          END IF
      END IF
*
*       Adopt triple or four-body regularization for strong interactions.
      IF (PMIN.GT.2.0*SEMI.OR.PERTM.GT.100.0*GSTAR) GO TO 30
      IF (RIJ.GT.RMIN) GO TO 100
*
*       Specify maximum size of unperturbed motion.
      IF (PERT2.GT.0.0) THEN
          RPERT = (100.0*GSTAR*(BODY(I) + BODY(JCOMP))/(2.0*PERT2))**0.33
      ELSE
          RPERT = 10.0*SEMI
      END IF
*
*       Compare with existing subsystem of same type (if any).
      IF (NSUB.GT.0.AND.KCHAIN.EQ.0) THEN
          IGO = 0
          CALL PERMIT(RPERT,IGO)
          IF (IGO.GT.0) GO TO 100
      END IF
*
      WHICH1 = ' TRIPLE '
      IF (JCOMP.GT.N) WHICH1 = ' QUAD   '
      IF (KCHAIN.GT.0) WHICH1 = ' CHAIN '
*
      IF (KZ(15).GT.1) THEN
          WRITE (6,20)  WHICH1, IPAIR, TIME, H(IPAIR), R(IPAIR),
     &                  BODY(I), BODY(JCOMP), PERT4, RIJ, PMIN,
     &                  EB1/EB, LIST(1,2*IPAIR-1)
   20     FORMAT (/,' NEW',A8,I2,'  T =',F8.2,'  H =',F6.0,
     &              '  R =',1PE8.1,'  M =',0P2F7.4,'  G4 =',1PE8.1,
     &              '  R1 =',E8.1,'  P =',E8.1,'  E1 =',0PF6.3,
     &              '  NP =',I2)
      CALL FLUSH(6)
      END IF
*
*       Predict coordinates and velocities of #JCOMP & c.m. to F3DOT.
      CALL XVPRED(JCOMP,-1)
      CALL XVPRED(I,0)
*
*       Save global index of intruder for TRIPLE or CHAIN.
      JCLOSE = JCOMP
*
*       Replace unperturbed near-synchronous binary by inert body in CHAIN.
      IF (KCHAIN.GT.0.AND.KZ(27).GT.0.AND.JCOMP.GT.N) THEN
          IF (SEMI0.LT.3.0*RT.AND.LIST(1,J1).EQ.0) THEN
              IF (SEMI0.LT.SEMI2) THEN
                  KPAIR = JPAIR
                  JPAIR = IPAIR
                  IPAIR = KPAIR
                  JCLOSE = N + JPAIR
              END IF
*       Check reduction of c.m. index (JPAIR becomes JPAIR - 1 if > IPAIR).
              IF (JPAIR.GT.IPAIR) JCLOSE = JCLOSE - 1
              IF (KZ(26).LT.2) THEN
                  JCOMP = 0
                  WRITE (6,25)  SEMI0, RIJ, R(JPAIR), GAMMA(JPAIR)
   25             FORMAT (' INERT BINARY    A0 RIJ R G ',1P,4E10.2)
              END IF
          ELSE
              JCLOSE = 0
          END IF
      END IF
*
*       Set phase indicator for calling TRIPLE or QUAD from MAIN.
      IPHASE = 4
      IF (JCOMP.GT.N) THEN
          IPHASE = 5
          K = IPAIR
          IPAIR = MIN(K,JCOMP - N)
          JPAIR = MAX(K,JCOMP - N)
*
*       Terminate each pair, beginning with the last.
          KSPAIR = JPAIR
          CALL KSTERM
      END IF
*
*       Terminate triple pair or first binary-binary collision pair.
      KSPAIR = IPAIR
      CALL KSTERM
*
*       Check switching of phase indicator to denote chain regularization.
      IF (KCHAIN.GT.0) THEN
          IPHASE = 8
      END IF
      GO TO 100
*
*       Begin check for merger of stable hierarchical configuration.
   30 RA = SEMI1*(1.0 + ECC1)
*       Do not allow merger in the inner region of perturbed eccentric orbit.
      IF (RIJ.LT.SEMI1.AND.LIST(1,I1).GT.0) GO TO 100
*
*       Skip merger for soft binding energy or hyperbolic orbit.
      IF (EB1.GT.-0.5*BODYM*ECLOSE.OR.RA.GT.2.0*RMIN) THEN
          GO TO 100
      END IF
*
*       Estimate the relative apocentre perturbations on body #I & JCOMP.
      PERT = PERT*(RA/RIJ)**3
      PERTA = PERT4*(RA/RIJ)**3
*
*       Check tidal capture option (synchronous or evolving binary orbit).
      IF (KZ(27).GT.0) THEN
*       Skip merger for tidal dissipation unless synchronous orbit.
          RT = 4.0*MAX(RADIUS(2*IPAIR-1),RADIUS(2*IPAIR),RADIUS(JCOMP))
          IF (SEMI*(1.0 - ECC).LT.RT.AND.ECC.GT.0.015) GO TO 100
      END IF
*
*       Ensure consistency of estimated perturbations with termination.
      PERT = PERT + PERTA
      IF (PERT4.GT.GMAX.OR.PERT.GT.0.25) GO TO 100
*
*       Skip merger if an outer binary is fairly perturbed or not hard.
      IF (JCOMP.GT.N) THEN
          IF (GAMMA(JPAIR).GT.1.0E-04.OR.H(JPAIR).GT.-ECLOSE) GO TO 100
      END IF
*
*       Form coefficients for stability test (Valtonen, Vistas Ast 32, 1988).
*     AM = (2.65 + ECC)*(1.0 + BODY(JCOMP)/BODY(I))**0.3333
*     FM = (2.0*BODY(JCOMP) - BODY(I))/(3.0*BODY(I))
*
*       Expand natural logarithm for small arguments.
*     IF (ABS(FM).LT.0.67) THEN
*         BM = FM*(1.0 - (0.5 - ONE3*FM)*FM)
*     ELSE
*         BM = LOG(1.0D0 + FM)
*     END IF
*
*       Adopt mass dependent criterion of Harrington (A.J. 80) & Bailyn.
*     PCRIT = AM*(1.0 + 0.7*BM)*SEMI
*
*       Employ the new stability criterion (MA 1997).
*     Q = BODY(JCOMP)/BODY(I)
*     IF (ECC1.LT.1.0) THEN
*         XFAC = (1.0 + Q)*(1.0 + ECC1)/SQRT(1.0 - ECC1)
*     ELSE
*         XFAC = 1.0 + Q
*     END IF
*       Include correction at small eccentricity (f(E) = 1.0 for now).
*     FE  = 1.0
*       Ensure the inner semi-major axis is used for subsequent tests.
      SEMI = -0.5*BODY(I)/H(IPAIR)
*     PCRIT = 2.8*FE*XFAC**0.4*SEMI
*
*       Choose the most dominant triple in case of two binaries.
      YFAC = 1.0
      IF (JCOMP.GT.N) THEN
          SFAC = (1.0 + Q)**0.4*SEMI
          SFAC2 = (1.0 + BODY(I)/BODY(JCOMP))**0.4*SEMI2
*       Adopt 10% fudge factor with linear dependence on smallest ratio.
          YFAC = 1.0 + 0.1*MIN(SEMI2/SEMI,SEMI/SEMI2)
          IF (SFAC2.GT.SFAC) THEN
              PCRIT = PCRIT*(SFAC2/SFAC)
          END IF
      END IF
*
*       Determine inclination for triple or dominant inner binary.
      IF (JCOMP.LE.N.OR.SEMI.LT.SEMI2) THEN
*       Resolve binary (just in case) and copy coordinates & velocities.
          CALL RESOLV(IPAIR,1)
          DO 42 K = 1,3
              XX(K,1) = X(K,I1)
              XX(K,2) = X(K,I2)
              XX(K,3) = X(K,JCOMP)
              VV(K,1) = XDOT(K,I1)
              VV(K,2) = XDOT(K,I2)
              VV(K,3) = XDOT(K,JCOMP)
  42      CONTINUE
          CALL INCLIN(XX,VV,X(1,I),XDOT(1,I),ANGLE)
      ELSE
          ANGLE = 0.0
      END IF
*
      QST = QSTAB(ECC,ECC1,ANGLE,BODY(I1),BODY(I2),BODY(JCOMP))
      IF (QST*SEMI.GT.PMIN) GO TO 100
*
*       Employ fudge factor for special cases.
      IF (ECC1.GT.0.99.AND.ECC1.LT.1.0) THEN
          YFAC = 0.9*YFAC
          IF (SEMI1.GT.500.0*SEMI) YFAC = 0.8*YFAC
      ELSE IF (ECC1.LT.0.99) THEN
*       Adopt an inclination fudge factor for ECC1 < 0.99.
          YFAC = YFAC - 0.3*ANGLE/180.0
      END IF
      IF (PMIN*(1.0 - PERT).LT.1.1*PCRIT) GO TO 100
*
*       Check whether the main perturber dominates the outer component.
      RIJ2 = (X(1,JMAX) - X(1,JCOMP))**2 + (X(2,JMAX) - X(2,JCOMP))**2 +
     &                                     (X(3,JMAX) - X(3,JCOMP))**2
      FMAX = (BODY(JMAX) + BODY(JCOMP))/RIJ2
      IF (FMAX.GT.(BODY(I) + BODY(JCOMP))/RJMIN2) GO TO 100
*
*       Check perturbed stability condition (PCRIT used by routine MERGE).
      IF (PMIN*(1.0 - PERT).LT.1.1*PCRIT) GO TO 100
*
*       Check Zare exchange stability criterion.
      IF (SEMI1.GT.100.0) THEN
          CALL ZARE(I1,I2,SP)
          IF (SP.LT.1.0) THEN
              WRITE (6,48)  TIME, Q, ECC, ECC1, SEMI, PMIN, PCRIT,
     &                      YFAC, SP
   48         FORMAT (' ZARE TEST    T Q E E1 A PM PCR YF SP ',
     &                               F8.2,F5.1,2F7.3,1P,3E9.1,0P,2F6.2)
              GO TO 100
          END IF
      END IF
*
*       Specify the final critical pericentre using the fudge factor.
      PCRIT = YFAC*PCRIT
*
      IF (NMERGE.EQ.MMAX) THEN
          WRITE (6,50)  NMERGE
   50     FORMAT (5X,'WARNING!   MERGER LIMIT REACHED   NMERGE =',I4)
          GO TO 100
      END IF
*
      WHICH1 = ' MERGER '
      IF (KZ(15).GT.1) THEN
          WRITE (6,20)  WHICH1, IPAIR, TIME, H(IPAIR), R(IPAIR),
     &                  BODY(I), BODY(JCOMP), PERT4, RIJ, PMIN,
     &                  EB1/EB, LIST(1,2*IPAIR-1)
      END IF
*
*       Copy pair index and set indicator for calling MERGE from MAIN.
      KSPAIR = IPAIR
      IPHASE = 6
*
  100 RETURN
*
      END
