      SUBROUTINE KSTERM
*
*
*       Termination of KS regularization.
*       ---------------------------------
*
      INCLUDE 'common3.h'
      REAL*8  SAVE(8)
*
*
*       Copy pair index (transmitted via COMMON to permit phase overlay).
      IPAIR = KSPAIR
*       Define index of first component & corresponding c.m.
      I1 = 2*IPAIR - 1
      ICM = N + IPAIR
*
*       Form square regularized velocity for the explicit binding energy.
      UPR2 = 0.0
      DO 1 K = 1,4
          UPR2 = UPR2 + UDOT(K,IPAIR)**2
    1 CONTINUE
*
*       Form KS scaling factors from energy and angular momentum relation.
      A1 = 0.25D0*BODY(ICM)/UPR2
*       Solve for C1 from H = (2*U'*U'*C1**2 - M)/(U*U*C2**2) with C2 = 1/C1.
      A2 = A1**2 + 0.5D0*H(IPAIR)*R(IPAIR)/UPR2
*
*       Check for undefined case (circular orbit or eccentric anomaly = 90).
      IF (A2.GT.0.0D0) THEN
          IF (A1.LT.1.0) THEN
*       Choose square root sign from eccentric anomaly (e*cos(E) = 1 - R/a).
              C1 = SQRT(A1 + SQRT(A2))
          ELSE
              C1 = SQRT(A1 - SQRT(A2))
          END IF
      ELSE
          C1 = 1.0
      END IF
*       Specify KS coordinate scaling from angular momentum conservation.
      C2 = 1.0/C1
*
*       Transform KS variables to yield the prescribed elements.
      R(IPAIR) = 0.0D0
      UPR2 = 0.0D0
      DO 2 K = 1,4
          U(K,IPAIR) = C2*U(K,IPAIR)
          UDOT(K,IPAIR) = C1*UDOT(K,IPAIR)
          U0(K,IPAIR) = U(K,IPAIR)
          R(IPAIR) = R(IPAIR) + U(K,IPAIR)**2
          UPR2 = UPR2 + UDOT(K,IPAIR)**2
    2 CONTINUE
*
*       Check optional diagnostic output for disrupted new hard binary.
      IF (KZ(8).EQ.0) GO TO 10
      IF (LIST(2,I1+1).NE.0.OR.H(IPAIR).GT.0.0) GO TO 10
      IF (GAMMA(IPAIR).GT.0.5.AND.JCOMP.GT.0.OR.IPHASE.EQ.7) THEN
          IF (JCOMP.EQ.0.OR.IPHASE.EQ.7) JCOMP = I1
          K = 0
          IF (JCOMP.GT.N) THEN
              J2 = 2*(JCOMP - N)
              K = LIST(2,J2)
          END IF
          I2 = I1 + 1
          SEMI = -0.5*BODY(ICM)/H(IPAIR)
          EB = -0.5*BODY(I1)*BODY(I2)/SEMI
          RI = SQRT((X(1,ICM) - RDENS(1))**2 +
     &              (X(2,ICM) - RDENS(2))**2 +
     &              (X(3,ICM) - RDENS(3))**2)
          WRITE (8,5)  TIME, NAME(I1), NAME(I2), K, NAME(JCOMP),
     &                 BODY(JCOMP), EB, SEMI, R(IPAIR), GAMMA(IPAIR), RI
    5     FORMAT (' END BINARY   T =',F6.1,'  NAME = ',2I4,I3,I4,
     &                       '  M(J) =',F6.2,'  EB =',F9.4,'  A =',F7.4,
     &                          '  R =',F7.4,'  G =',F5.2,'  RI =',F5.2)
      END IF
*
   10 IF (KZ(10).GT.1) THEN
          RI = SQRT((X(1,ICM) - RDENS(1))**2 +
     &              (X(2,ICM) - RDENS(2))**2 +
     &              (X(3,ICM) - RDENS(3))**2)
          WRITE (6,15)  TIME, BODY(I1), BODY(I1+1), DTAU(IPAIR),
     &                  R(IPAIR), RI, H(IPAIR), IPAIR, GAMMA(IPAIR),
     &                  STEP(I1), LIST(1,I1)
   15     FORMAT (/,' END KSREG    TIME =',F7.2,2F7.3,F10.3,1PE10.1,
     &                                   0PF7.2,F9.2,I4,F8.3,1PE10.1,I5)
      END IF
*
*       Obtain global coordinates & velocities (skip mass-loss case).
      IF (IPHASE.NE.-1) CALL RESOLV(IPAIR,2)
*
*       Reduce pair index, total number & single particle index.
      NPAIRS = NPAIRS - 1
      NTOT = N + NPAIRS
      IFIRST = 2*NPAIRS + 1
*
*       Save name of components & flag for modifying LISTD in UPDATE.
      JLIST(1) = NAME(I1)
      JLIST(2) = NAME(I1+1)
      JLIST(3) = LIST(2,I1+1)
*
*       Skip adjustment of tables if last or only pair being treated.
      IF (IPAIR.EQ.NPAIRS + 1) GO TO 60
*
*       Move the second component before the first.
      DO 50 KCOMP = 2,1,-1
          I = 2*IPAIR - 2 + KCOMP
*
          DO 30 K = 1,3
              SAVE(K) = X(K,I)
              SAVE(K+3) = X0DOT(K,I)
   30     CONTINUE
*       Current velocity has been set in routine RESOLV.
          SAVE(7) = BODY(I)
          SAVE(8) = RADIUS(I)
          NAMEI = NAME(I)
          LAST = 2*NPAIRS - 1 + KCOMP
*
*       Move up global variables of other components.
          DO 40 J = I,LAST
              DO 35 K = 1,3
                  X(K,J) = X(K,J+1)
   35     CONTINUE
              BODY(J) = BODY(J+1)
              RADIUS(J) = RADIUS(J+1)
              NAME(J) = NAME(J+1)
              STEP(J) = STEP(J+1)
              T0(J) = T0(J+1)
   40     CONTINUE
*
*       Set new component index and copy basic variables.
          I = LAST + 1
          DO 45 K = 1,3
              X(K,I) = SAVE(K)
              X0DOT(K,I) = SAVE(K+3)
              XDOT(K,I) = SAVE(K+3)
   45     CONTINUE
          BODY(I) = SAVE(7)
          RADIUS(I) = SAVE(8)
          NAME(I) = NAMEI
   50 CONTINUE
*
*       Update all regularized variables.
      CALL REMOVE(IPAIR,2)
*
*       Remove old c.m. from all COMMON tables (no F & FDOT correction).
      CALL REMOVE(ICM,3)
*
*       Set new global index of first & second component.
   60 ICOMP = 2*NPAIRS + 1
      JCOMP = ICOMP + 1
*
*       Modify all relevant COMMON list arrays.
      CALL UPDATE(IPAIR)
*
*       Form new force polynomial (skip triple, quad, merge & collision).
      IF (IPHASE.LT.4) THEN
          JFIRST = JCOMP + 1
*
*       Predict current coordinates & velocities for all other particles.
      CALL XVPRED(JFIRST,NTOT)
*
*       Obtain force polynomials (first F & FDOT, then F2DOT & F3DOT).
          CALL FPOLY1(ICOMP,JCOMP,2)
          CALL FPOLY2(ICOMP,JCOMP,2)
*
*       See whether to include single components in NLIST.
          IF (T0(ICOMP) + STEP(ICOMP).LT.TLIST) THEN
              CALL NLMOD(ICOMP,1)
          END IF
          IF (T0(JCOMP) + STEP(JCOMP).LT.TLIST) THEN
              CALL NLMOD(JCOMP,1)
          END IF
      END IF
*
*       Check updating of global index for chain c.m.
      IF (NCHAIN.GT.0) THEN
          CALL CHFIND
      END IF
*
      RETURN
*
      END
