      SUBROUTINE NBINT(I)
*
*
*       Standard N-body integration.
*       ----------------------------
*
      INCLUDE 'common3.h'
      COMMON/EXTRA/  RPERT2,I1,I2
      COMMON/CHAINC/  XC(3,NCMAX),BODYC(NCMAX),ICH,LISTC(100)
      REAL*8  FIRR(3),F1DOT(3),F2DOT(3)
*
*
*       Predict the coordinates of all particles to order FDOT2.
      DO 20 J = IFIRST,NTOT
          S = TIME - T0(J)
          X(1,J) = (((FDOT2(1,J)*S + FDOT(1,J))*S + F(1,J))*S +
     &                                           X0DOT(1,J))*S + X0(1,J)
          X(2,J) = (((FDOT2(2,J)*S + FDOT(2,J))*S + F(2,J))*S +
     &                                           X0DOT(2,J))*S + X0(2,J)
          X(3,J) = (((FDOT2(3,J)*S + FDOT(3,J))*S + F(3,J))*S +
     &                                           X0DOT(3,J))*S + X0(3,J)
   20 CONTINUE
*
      IF (STEP(I).GT.SMIN) GO TO 100
*
*       Include D3 term in prediction of dominant neighbours.
      DO 30 J = IFIRST,NTOT
          IF (STEP(J).GT.SMIN.OR.J.EQ.I) GO TO 30
          S = TIME - T0(J)
          S2 = S*S
          S5 = 0.05D0*S*S2*S2
*
          X(1,J) = D3(1,J)*S5 + X(1,J)
          X(2,J) = D3(2,J)*S5 + X(2,J)
          X(3,J) = D3(3,J)*S5 + X(3,J)
   30 CONTINUE
*
*       Set indicator for both components in case of new regularization.
  100 KCOMP = 1
*       Check regularization criterion for single particles.
      IF (STEP(I).GT.DTMIN.OR.I.GT.N) GO TO 110
*
*       See whether dominant body can be regularized.
      IF (STEP(I).LT.0.999*(T0(I) - T1(I)).AND.NPAIRS.LT.KMAX) THEN
          CALL SEARCH(I,KCOMP)
      END IF
*
*       Predict coordinates and velocities of body #I to order F3DOT.
  110 DT = TIME - T0(I)
      T1PR = T0(I) - T1(I)
      T2PR = T0(I) - T2(I)
      T12PR = T1PR + T2PR
      DT06 = 0.6D0*DT
      DT19 = ONE9*DT
      DT12 = ONE12*DT
      DT34 = 0.75D0*DT
      DT32 = 1.5D0*DT
      DT20 = 2.0D0*DT  
      S2 = DT*DT
      S5 = 0.05D0*DT*S2*S2
*
      DO 115 K = 1,3
          F2DOTK = 12.0D0*FDOT2(K,I)
          F3DOTK = D3(K,I)
          X(K,I) = F3DOTK*S5 + X(K,I)
          X0DOT(K,I) = (((F3DOTK*DT34 + F2DOTK)*DT19 + FDOT(K,I))*DT32 +
     &                                         F(K,I))*DT20 + X0DOT(K,I) 
          FIRR(K) = 0.0D0
  115 CONTINUE
*
*       Check regularization index.
      IF (KCOMP.EQ.1) GO TO 120
*
*       Note I = JCOMP in routine SEARCH for new regularization.
      IF (I.EQ.ICOMP) GO TO 120
*       Switch back to original body #I and complete integration cycle.
      I = ICOMP
      GO TO 110
*
*       Obtain total force.
  120 XI = X(1,I)
      YI = X(2,I)
      ZI = X(3,I)
      JMIN = 0
*     RJMIN2 = RMIN22
      RJMIN2 = 25.0*RMIN22
*       Choose force loop for single particle or regularized c.m. body.
      IF (I.LE.N) GO TO 130
*
*       Set KS pair index & c.m. approximation distance (also for CMF).
      IPAIR = I - N
      RPERT2 = CMSEP2*R(IPAIR)**2
*
*       Adopt c.m. approximation for small total perturbation.
      IF (GAMMA(IPAIR).GE.GMIN) THEN
*       Obtain force on perturbed c.m. body.
          CALL CMF(I,IPAIR,XI,YI,ZI,FIRR)
          GO TO 178
      ELSE
*       Set index of first component for routine KEPLER.
          I1 = 2*IPAIR - 1
      END IF
*
*       Sum over single particles (unperturbed case included).
  130 DO 140 K = IFIRST,N
          IF (K.EQ.I) GO TO 140
          A1 = X(1,K) - XI
          A2 = X(2,K) - YI
          A3 = X(3,K) - ZI
          RIJ2 = A1*A1 + A2*A2 + A3*A3
          IF (RIJ2.LT.RJMIN2) THEN
              RJMIN2 = RIJ2
              JMIN = K
          END IF
          A6 = BODY(K)/(RIJ2*SQRT(RIJ2))
          FIRR(1) = FIRR(1) + A1*A6
          FIRR(2) = FIRR(2) + A2*A6
          FIRR(3) = FIRR(3) + A3*A6
  140 CONTINUE
*
*       See whether any c.m. particles should be included.
      IF (NPAIRS.EQ.0) GO TO 170
*
*       Set index for distinguishing c.m. or resolved components.
      KDUM = 0
*
*       Sum over regularized c.m. particles.
      N1 = N + 1
      DO 160 JDUM = N1,NTOT
          IF (JDUM.EQ.I) GO TO 160
          K = JDUM
          A1 = X(1,K) - XI
          A2 = X(2,K) - YI
          A3 = X(3,K) - ZI
          RIJ2 = A1*A1 + A2*A2 + A3*A3
*
*       See whether c.m. approximation applies (ignore unperturbed case).
          J = K - N
          IF (RIJ2.GT.CMSEP2*R(J)**2) GO TO 158
*
*       Resolve components of pair #J.
          CALL KSRES(J,J1,J2,RIJ2)
          KDUM = J1
          K = KDUM
*       Sum over individual components of pair #J.
  156     A1 = X(1,K) - XI
          A2 = X(2,K) - YI
          A3 = X(3,K) - ZI
          RIJ2 = A1*A1 + A2*A2 + A3*A3
*       Adopt c.m. approximation outside the effective perturber sphere.
  158     A6 = BODY(K)/(RIJ2*SQRT(RIJ2))
          FIRR(1) = FIRR(1) + A1*A6
          FIRR(2) = FIRR(2) + A2*A6
          FIRR(3) = FIRR(3) + A3*A6
          IF (K.EQ.KDUM) THEN
              K = K + 1
              GO TO 156
          END IF
  160 CONTINUE
*
*       Include treatment for regularized clump.
  170 IF (NCH.GT.0) THEN
*       Distinguish between chain c.m. and any other particle.
          IF (NAME(I).EQ.0) THEN
              CALL CHF(I,XI,YI,ZI,FIRR)
          ELSE
              NNBC = LISTC(1) + 1
*       Search the chain perturber list for #I.
              DO 175 L = 2,NNBC
                  J = LISTC(L)
                  IF (J.GT.I) GO TO 178
                  IF (J.EQ.I) THEN
                      CALL FCHAIN(I,XI,YI,ZI,FIRR)
                  END IF
  175         CONTINUE
          END IF
      END IF 
*
*       Set time intervals for corrector and update total force times.
  178 DT1 = TIME - T1(I)
      DT2 = TIME - T2(I)
      DT3 = TIME - T3(I)
      T3PR = T0(I) - T3(I)
      S1 = DT + DT1
      S2 = T1PR*T2PR
      S3 = S2*T3PR
      S4 = S2 + T3PR*T12PR
      S5 = T12PR + T3PR
      S6 = (((0.6666666666667D0*DT + S5)*DT06 + S4)*DT12 + ONE6*S3)*DT
      S7 = ((0.2D0*DT + 0.25D0*S5)*DT + ONE3*S4)*DT + 0.5D0*S3
      T3(I) = T2(I)
      T2(I) = T1(I)
      T1(I) = T0(I)
      T0(I) = TIME
      A1 = 1.0/DT
      A2 = 1.0/DT1
      A3 = 1.0/DT2
      A4 = DT*DT/DT3
*
*       Check options for drag force and external force.
      IF (KZ(12).GT.0) THEN
          CALL DRAG(I,FIRR)
      END IF
      IF (KZ(14).GT.0) THEN
          CALL XTRNLF(I,FIRR)
      END IF
*
*       Form new differences and include semi-iteration for total force.
      DO 180 K = 1,3
          D1K = (FIRR(K) - 2.0D0*F(K,I))*A1
          D2K = (D1K - D1(K,I))*A2
          D3K = (D2K - D2(K,I))*A3
          F4DOTK = (D3K - D3(K,I))*A4
          D1(K,I) = D1K
          D2(K,I) = D2K
          D3(K,I) = D3K
          X(K,I) = F4DOTK*S6 + X(K,I)
          X0(K,I) = X(K,I)
          X0DOT(K,I) = F4DOTK*S7 + X0DOT(K,I)
          XDOT(K,I) = X0DOT(K,I)
          F(K,I) = 0.5D0*FIRR(K)
          F1DOT(K) = (D3K*DT1 + D2K)*DT + D1K
          F2DOT(K) = D3K*S1 + D2K
          FDOT(K,I) = ONE6*F1DOT(K)
          FDOT2(K,I) = ONE12*F2DOT(K)
*       Scaling of F, FDOT & FDOT2 by 1/2, 1/6 & 1/24 for fast prediction.
  180 CONTINUE
*
*     IF (NAME(I).EQ.1.OR.NAME(I).EQ.261) THEN
*     WRITE (6,300) I, (X0DOT(K,I),K=1,3)
* 300 FORMAT (' HELLO!    I X0D ',I5,1P,3E10.2)
*     END IF
*       Check optional two-body tidal effect.
      IF (KZ(27).LT.0) THEN
          IF (JMIN.GT.0) CALL NBTIDE(I,JMIN,RJMIN2)
          IF (IPHASE.EQ.1) GO TO 200
      END IF
*
      IF (KCOMP.GT.1) THEN
*       Set indicator for calling KSREG from MAIN (permits overlay).
          IPHASE = 1
*       Ensure ICOMP < JCOMP for routine KSREG.
          ICOMP = MIN(ICOMP,JCOMP)
          JCOMP = MAX(I,JCOMP)
*
*       Start regularization of close particles.
          GO TO 200
      END IF
*
*       Check for boundary reflection (RI2 < 0 denotes new polynomials).
      IF (KZ(29).GT.0) THEN 
          RI2 = (XI - RDENS(1))**2 + (YI - RDENS(2))**2 +
     &                               (ZI - RDENS(3))**2
          IF (RI2.GT.RSPH2) THEN
               CALL REFLCT(I,RI2)
          END IF
          IF (RI2.LT.0.0) IPHASE = 8
      END IF
*
  200 NCOUNT(1) = NCOUNT(1) + 1
      NSTEPI = NSTEPI + 1
*
      RETURN
*
      END
