      SUBROUTINE OUTPUT
*
*
*       Output and data save.
*       ---------------------
*
      INCLUDE 'common3.h'
      COMMON/ECHAIN/  ECH
      REAL*4  XS(3,NMAX),VS(3,NMAX),BODYS(NMAX),AS(20)
      LOGICAL  FIRST
      DATA  FIRST /.TRUE./
      SAVE  FIRST
*
*
*       Obtain energy error in case routine ADJUST not called recently.
      IF (TIME.GE.TADJ.OR.TIME.LE.0.0D0) GO TO 10
*
*       Predict X & XDOT for all particles (except unperturbed pairs).
      CALL XVPRED(IFIRST,NTOT)
*
*       Obtain the total energy at current time (resolve all KS pairs).
      CALL ENERGY
*
*       Include KS pairs, triple & quad, chain, mergers & collisions.
      IF (NCH.EQ.0) THEN
          ECH1 = 0.0
      ELSE
          ECH1 = ECH
      END IF
      ETOT = ZKIN - POT + ETIDE + EBIN + ESUB + EMERGE + ECOLL + ECH1
*
*       Update energies and form the relative error (divide by ZKIN or ETOT).
      BE(2) = BE(3)
      BE(3) = ETOT
      DE = BE(3) - BE(2)
      DETOT = DETOT + DE
      DE = DE/MAX(ZKIN,ABS(ETOT))
*       Save sum of relative energy error for main output and accumulate DE.
      ERROR = ERROR + DE
      ERRTOT = ERRTOT + DE
*
*       Find density centre & core radius (Casertano & Hut, Ap.J. 298, 80).
      IF (N.GT.10.AND.KZ(29).EQ.0) THEN
          CALL CORE
      END IF
*
*       Check optional sorting of Lagrangian radii & half-mass radius.
      IF (KZ(7).GT.0) THEN
          CALL LAGR(RDENS)
      END IF
*
*       Initialize diagnostic variables.
   10 NP = 0
      IUNP = 0
      AMIN = 100.0
*
*       Find smallest semi-major axis and count unperturbed KS pairs.
      DO 20 IPAIR = 1,NPAIRS
          NP = NP + LIST(1,2*IPAIR-1)
          SEMI = -0.5*BODY(N+IPAIR)/H(IPAIR)
          IF (SEMI.GT.0.0) AMIN = MIN(AMIN,SEMI)
          IF (LIST(1,2*IPAIR-1).EQ.0) IUNP = IUNP + 1
   20 CONTINUE
*
*       Set density centre displacement.
      RD = SQRT(RDENS(1)**2 + RDENS(2)**2 + RDENS(3)**2)
*
*       Check print frequency indicator & optional model counter.
      NPRINT = NPRINT + 1
      IF (NPRINT.GT.NFIX.OR.TIME.LE.0.0) THEN
          NPRINT = 1
          IF (KZ(3).GT.0) MODEL = MODEL + 1
      END IF
*
*       Form binary & merger energy ratios.
      EB = EBIN/(ZKIN - POT)
      EM = EMERGE/(ZKIN - POT)
*
*       Print main output diagnostics.
      I6 = TSCALE*TIME
*
      WRITE (6,40)  TIME, N, NPAIRS, NMERGE, NSUB, NSTEPI, NSTEPU,
     &              NICONV, ERROR, BE(3)
   40 FORMAT (//,' T =',F6.1,'  N =',I4,'  KS =',I2,'  NM =',I2,
     &           '  NS =',I2,'  NSTEPS =',2I10,'  NICONV =',I8,
     &           '  DE =',F10.6,'  E =',F10.6)
*
      IF (KZ(21).GT.0) THEN
          CALL CPUTIM(TCOMP)
          DMIN1 = MIN(DMIN1, DMIN2, DMIN3, DMIN4, DMINC)
          WRITE (6,45)  NRUN, MODEL, TCOMP, DMIN1, DMIN2, DMIN3, DMIN4,
     &                  AMIN, RMAX, NBREF
   45     FORMAT (/,' NRUN =',I3,'  M# =',I3,'  CPU =',F7.2,
     &              '  DMIN =',1P4E8.1,'  AMIN =',E9.1,'  RMAX =',E8.1,
     &              '  NBREF =',I7)
      END IF
*
      WRITE (6,50)
   50 FORMAT (/,' <R>  RTIDE  RDENS   RC    NC   MC   RHOD   RHOM',
     &                                         '    UN  NP  RCM    VCM',
     &                         '        AZ     EB/E   EM/E   TCR    T6')
*
      WRITE (6,55)  RSCALE, RTIDE, RD, RC, NC, ZMC, RHOD, RHOM,
     &              IUNP, NP, CMR(4), CMRDOT(4), AZ, EB, EM, TCR, I6
   55 FORMAT (F5.2,F6.1,F7.2,F6.2,I5,F7.3,F6.1,F7.1,I5,I4,F7.3,F8.4,
     &                                       F10.6,1P,2E10.2,0P,F6.2,I5)
*
      WRITE (6,65)
   65 FORMAT (/,5X,'NKSTRY  NKSREG  NKSHYP     NKSPER  NPRECT  NKSMOD',
     &             '   NTTRY  NTRIP  NQUAD  NCHAIN  NMERG  NSTEPT',
     &             '  NSTEPQ  NSTEPC')
      WRITE (6,70)  NKSTRY, NKSREG,  NKSHYP, NKSPER, NPRECT, NKSMOD,
     &              NTTRY, NTRIP, NQUAD, NCHAIN, NMERG, NSTEPT,
     &              NSTEPQ, NSTEPC
   70 FORMAT (' #2',3I8,I11,3I8,2I7,I8,I7,3I8)
*
*       Check output for tidal capture or collisions.
      IF (KZ(27).GT.0.AND.NDISS + NCOLL.GT.0) THEN
          WRITE (6,75)
   75     FORMAT (/,5X,'NDISS  NTIDE  NSYNC  NCOLL    EBIN   ESYNC',
     &               '   ECOLL  DMINC')
          WRITE (6,80)  NDISS, NTIDE, NSYNC, NCOLL,  EBIN, ESYNC, ECOLL,
     &                  DMINC
   80     FORMAT (' #3',4I7,3F8.3,1P,E9.1)
      END IF
*
*       Reset minimum encounter distances & maximum apocentre separation.
      DMIN2 = 100.0
      DMIN3 = 100.0
      DMIN4 = 100.0
      DMINC = 100.0
      RMAX = 0.0
*
*       Exit if error exceeds restart tolerance (TIME < TADJ means no CHECK).
      IF (ABS(ERROR).GT.5.0*QE.AND.TIME.LT.TADJ) GO TO 100
*
*       Check optional analysis & output of KS binaries.
      IF (KZ(8).GT.0) THEN
          CALL BINOUT
      END IF
*
*       Check optional output of single bodies & binaries.
      CALL BODIES
*
*       See whether to write data bank of binary diagnostics on unit 9.
      IF (KZ(8).GE.3.AND.NPAIRS.GT.0) THEN
          CALL BINDAT
      END IF
*
*       Check optional writing of data on unit 3 (frequency NFIX). 
      IF (KZ(3).EQ.0.OR.NPRINT.NE.1) GO TO 100
*
      AS(1) = TIME
      AS(2) = FLOAT(NPAIRS)
      AS(3) = RBAR
      AS(4) = ZMBAR
      AS(5) = RTIDE
      AS(6) = TIDAL(4)
      AS(7) = RDENS(1)
      AS(8) = RDENS(2)
      AS(9) = RDENS(3)
      AS(10) = TIME/TCR
      AS(11) = TSCALE
      AS(12) = VSTAR
      AS(13) = RC
      AS(14) = NC
      AS(15) = 0.0
      AS(16) = RHOM
      AS(17) = RHOD
      AS(18) = RSCALE
      AS(19) = 0.0
      AS(20) = DMIN1
*
*       Convert masses, coordinates & velocities to single precision.
      DO 90 I = 1,NTOT
          BODYS(I) = BODY(I)
          DO 85 K = 1,3
              XS(K,I) = X(K,I)
              VS(K,I) = XDOT(K,I)
   85     CONTINUE
   90 CONTINUE
*
*       Split into WRITE (3) NTOT & WRITE (3) ..  if disc instead of tape.
      IF (FIRST) THEN
          OPEN (UNIT=3,STATUS='NEW',FORM='UNFORMATTED',FILE='OUT3')
          FIRST = .FALSE.
      END IF
      NK = 20
      WRITE (3)  NTOT, MODEL, NRUN, NK
      WRITE (3)  (AS(K),K=1,NK), (BODYS(J),J=1,NTOT),
     &           ((XS(K,J),K=1,3),J=1,NTOT), ((VS(K,J),K=1,3),J=1,NTOT),
     &           (NAME(J),J=1,NTOT)
      CALL FLUSH(3)
*     CLOSE (UNIT=3)
*
*       Update output interval and initialize the corresponding error.
  100 TNEXT = TNEXT + DELTAT
      ERROR = 0.0D0
*
      RETURN
*
      END
