      SUBROUTINE XTRNLD(I1,I2,KCASE)
*
*
*       External force & derivatives.
*       -----------------------------
*
      INCLUDE 'common3.h'
*
*
*       See whether to include the galactic tidal force.
      IF (TIDAL(1).GT.0.0.AND.KCASE.EQ.1) THEN
*       Include tidal force & first derivative (I1 = I2 for single body).
          DO 10 I = I1,I2
              F(1,I) = F(1,I) + TIDAL(1)*X(1,I) + TIDAL(4)*XDOT(2,I)
              F(2,I) = F(2,I) - TIDAL(4)*XDOT(1,I)
              F(3,I) = F(3,I) + TIDAL(3)*X(3,I)
              D1(1,I) = D1(1,I) + TIDAL(1)*XDOT(1,I) + TIDAL(4)*F(2,I)
              D1(2,I) = D1(2,I) - TIDAL(4)*F(1,I)
              D1(3,I) = D1(3,I) + TIDAL(3)*XDOT(3,I)
   10     CONTINUE
      END IF
*
      IF (TIDAL(1).GT.0.0.AND.KCASE.EQ.2) THEN
*       Add the second and third derivatives due to the tidal field.
          DO 20 I = I1,I2
              D2(1,I) = D2(1,I) + TIDAL(1)*F(1,I) + TIDAL(4)*FDOT(2,I)
              D2(2,I) = D2(2,I) - TIDAL(4)*FDOT(1,I)
              D2(3,I) = D2(3,I) + TIDAL(3)*F(3,I)
              D3(1,I) = D3(1,I) + TIDAL(1)*FDOT(1,I) + TIDAL(4)*D2(2,I)
              D3(2,I) = D3(2,I) - TIDAL(4)*D2(1,I)
              D3(3,I) = D3(3,I) + TIDAL(3)*FDOT(3,I)
   20     CONTINUE
      END IF
*
      RETURN
*
      END
