FC = gfortran
FFLAGS += -g -fPIC -fopenmp -march=native -I../../Block
ifeq ($(debug), on)
FFLAGS += -Wall -Wextra -g -fbacktrace
#FFLAGS += -O1 -fbounds-check
 FFLAGS += -O0 -g -fbacktrace -fbounds-check -ffpe-trap=invalid,zero,overflow -finit-real=nan -finit-integer=1000000000
else
 FFLAGS += -O0 -ffast-math
endif
ifeq ($(avx), enable)
 FFLAGS += -mavx
endif

LIBCUDA = -L /usr/local/cuda/lib64 -lcudart

GC = gfortran

LD_GPU = -fPIC -fopenmp $(LIBCUDA) -lstdc++
#LD_GPU += -B /usr/share/libhugetlbfs -Wl,--hugetlbfs-link=B

LD_SSE = -fPIC -fopenmp -lstdc++
#LD_SSE += -B /usr/share/libhugetlbfs -Wl,--hugetlbfs-link=B

#default value of chainmode is chain
chainmode ?= chain

ifneq ($(ksblock), on)
VPATH = ../../Ncode
else
VPATH = ../../Block
endif

ifeq ($(chainmode), chain)
VPATH += :../../Chain:../../Nchain
endif

ifeq ($(chainmode), archain)
VPATH += :../../ARchain:../../ARint
endif

ifneq ($(ksblock), on)
SOURCE = \
nbody6.f adjust.f assess.f bindat.f binev.f binout.f binpop.f \
block.f bodies.f brake.f brake2.f brake3.f bsetid.f chaos0.f \
chaos.f check.f checkl.f chrect.f clint.f cloud.f cloud0.f \
cmbody.f cmcorr.f cmfirr.f cmfreg.f coal.f comenv.f core.f \
corerd.f cputim.f data.f decide.f define.f deform.f degen.f \
delay.f dgcore.f dtchck.f eccmod.f ecirc.f edot.f efac2.f \
efac3.f expel.f energy.f escape.f events.f evolve.f expand.f \
fbulge.f fclose.f fcloud.f fcorr.f fdisk.f fhalo.f ficorr.f findj.f \
findm.f flyby.f fnuc.f fpcorr.f fpert.f fpoly1.f fpoly2.f \
freeze.f gcinit.f gcint.f giant.f giant3.f gntage.f grrad.f \
hcorr.f hiarch.f hicirc.f hidat.f higrow.f himax.f himax2.f \
himod.f hipop.f hirect.f histab.f hivel.f hmdot.f hmdot2.f \
hotsys.f hrdiag.f hrplot.f hut.f hut2.f iblock.f imf.f imfbd.f \
imf2.f impact.f induce.f inext.f input.f insert.f instar.f \
intgrt.f intide.f jacobi.f kepler.f kick.f kick2.f kozai.f ksapo.f \
kscorr.f ksin2.f ksinit.f ksint.f kslist.f ksmod.f ksperi.f \
kspert.f kspoly.f kspred.f ksrect.f ksreg.f ksres.f ksres2.f ksterm.f \
kstide.f lagr.f lagr2.f levels.f magbrk.f matrix.f mdot.f merge.f \
merge2.f mix.f mloss.f mlwind.f modify.f mrenv.f mtrace.f mydump.f \
nbhist.f nbint.f nblist.f nbpot.f nbrem.f nbrest.f nbsort.f nbtide.f \
newtev.f nstab.f ntint.f offset.f orbit.f output.f peri.f permit.f \
pfac.f plpot1.f poti.f premsf.f proto_star.f qtides.f ran2.f reflct.f \
regint.f remove.f rename.f reset.f reset2.f resolv.f rkint.f rl.f roche.f \
rpmax.f rpmax2.f rpmin.f scale.f search.f setup.f setup2.f shrink.f \
sort1.f spiral.f stability.f star.f start.f stepk.f steps.f stumpf.f \
subint.f swap.f sweep.f synch.f tail0.f tcirc.f tides.f tides2.f \
tides3.f touch.f tpert.f trdot.f trdot2.f trflow.f tstab.f tstep.f \
units.f unpert.f update.f verify.f xtrnl0.f xtrnld.f xtrnlf.f \
xtrnlp.f xtrnlt.f xtrnlv.f xvpred.f zare.f zcnsts.f zero.f zfuncs.f \
triple.f derqp3.f difsy3.f erel3.f extend.f qpmod3.f stabl3.f \
stablz.f start3.f subsys.f tperi.f trans3.f \
quad.f derqp4.f difsy4.f endreg.f erel4.f ichain.f newreg.f newsys.f \
qpmod4.f rchain.f rsort.f stabl4.f start4.f status.f trans4.f \
brake4.f ksrot.f expand2.f deform2.f circ.f spinup.f kstran.f qstab.f \
pnpert2.f fpolyi.f brent.f
else
#KS block-step version
SOURCE = \
adjust.f assess.f  bindat.f binev.f   binout.f binpop.f block.f  bodies.f \
brake.f  brake2.f  brake3.f brake4.f  bsetid.f chaos.f  chaos0.f check.f  \
checkl.f chrect.f  circ.f   clint.f   cloud.f  cloud0.f cmbody.f cmcorr.f \
cmfirr.f cmfreg.f  coal.f   comenv.f  core.f   corerd.f cputim.f data.f   \
decide.f define.f  deform.f deform2.f degen.f  delay.f  derqp3.f derqp4.f \
dgcore.f difsy3.f  difsy4.f dtchck.f  eccmod.f ecirc.f  edot.f   efac2.f  \
efac3.f  endreg.f  energy.f erel3.f   erel4.f  escape.f events.f evolve.f \
expand.f expand2.f expel.f  extend.f  fbulge.f fclose.f fcloud.f fcorr.f  \
fdisk.f  fhalo.f   ficorr.f findj.f   findm.f  flyby.f  fnuc.f   fpcorr.f \
fpert.f  fpoly1.f  fpoly2.f freeze.f  gcinit.f gcint.f  giant.f  giant3.f \
gntage.f grrad.f   hcorr.f  hiarch.f  hicirc.f hidat.f  higrow.f himax.f  \
himax2.f himod.f   hipop.f  hirect.f  histab.f hivel.f  hmdot.f  hmdot2.f \
hotsys.f hrdiag.f  hrplot.f hut.f     hut2.f   iblock.f ichain.f imf.f    \
imf2.f   imfbd.f   impact.f induce.f  inext.f  input.f  insert.f instar.f \
intgrt.f intide.f  jacobi.f kepler.f  kick.f   kick2.f  kozai.f  ksapo.f  \
kscorr.f ksin2.f   ksinit.f ksint.f   ksintp.f kslist.f ksmod.f  ksperi.f \
kspert2.f kspoly.f kspred.f  ksrect.f ksreg.f  ksres.f  ksres2.f \
ksrot.f  ksterm.f  kstide.f lagr.f    lagr2.f  levels.f magbrk.f matrix.f \
mdot.f   merge.f   merge2.f mix.f     mloss.f  mlwind.f modify.f mrenv.f  \
mtrace.f mydump.f  nbhist.f nbint.f   nblist.f nbody6.f nbpot.f  nbrem.f  \
nbrest.f nbsort.f  nbtide.f newreg.f  newsys.f newtev.f nstab.f \
ntint.f   offset.f orbit.f   output.f peri.f   permit.f pfac.f   \
plpot1.f pnpert2.f poti.f   premsf.f  proto_star.f qpmod3.f qpmod4.f \
qtides.f quad.f    ran2.f   rchain.f  reflct.f regint.f remove.f rename.f \
reset.f  reset2.f  resolv.f rkint.f rl.f roche.f rpmax.f rpmax2.f \
rpmin.f  rsort.f   scale.f  search.f  setup.f  setup2.f shrink.f sort1.f  \
spinup.f spiral.f  stability.f stabl3.f stabl4.f stablz.f star.f \
start.f  start3.f  start4.f status.f  stepi.f  stepk.f  steps.f  stumpf.f \
subint.f subsys.f  swap.f   sweep.f synch.f  tail0.f tcirc.f \
tides.f  tides2.f  tides3.f touch.f tperi.f  tpert.f trans3.f trans4.f \
trdot.f  trdot2.f  trflow.f triple.f tstab.f tstep.f units.f  unpert.f \
update.f verify.f  xtrnl0.f xtrnld.f  xtrnlf.f xtrnlp.f xtrnlt.f xtrnlv.f \
xvpred.f zare.f zcnsts.f zero.f zfuncs.f kstran2.f qstab.f \
ksintr.f ksperit.f nbpot2.f resolvt.f resolvx.f xinit.f xtrnlv2.f \
xupdate.f xvpredx.f query.f fpolyi.f brent.f
endif

ifeq ($(chainmode), chain)
SOURCE += \
cfuncs.f chain.f chstab.f const.f cstab2.f cstab3.f cstab4.f cstab5.f \
derqp.f difsy1.f erel.f hpsort.f inclin.f invert.f ksphys.f physks.f \
qforce.f qpmod.f r2sort.f recoil.f redraw.f select.f slow.f stablc.f \
swcond.f switch.f transk.f transq.f transx.f vector.f xtf.f xtrnlu.f \
ycopy.f ysave.f \
absorb.f chaos2.f chdata.f chfind.f chfirr.f chinit.f chlist.f chmod.f \
chpert.f chpot.f chterm.f expel2.f fchain.f ghost.f giant2.f kcpert.f \
reduce.f reinit.f renew.f setsys.f tchain.f xcpred.f xtpert.f
endif

ifeq ($(chainmode), archain)
SOURCE += \
arc.f chain.f chstab.f cstab2.f cstab3.f cstab4.f emax1.f erel.f \
grbin.f hpsort.f inclin.f ksphys.f physks.f pnpert.f r2sort.f \
absorb.f bhstab.f bhstat.f chdata.f chfind.f chfirr.f chinit.f chlist.f \
chmod.f chpert.f chpot.f chterm2.f chterm.f const.f cpertj.f cpertx.f \
decorr.f expel2.f fchain.f ffdot.f ghost.f infall.f inject.f kcpert.f \
reduce.f reinit.f renew.f setsys.f tchain.f xcpred.f xtpert2.f xtpert.f

endif

#routines added by GPU modules
SOURCE += \
check3.f checkl2.f cmfirr2.f energy2.f fpcorr2.f gpucor.f \
jpred2.f jpred.f ksres3.f nbintp.f phicor.f repair.f sweep2.f bhplot.f \
fpoly0.f kspinit.f kspreg.f

OBJECTS = $(SOURCE:.f=.o)
OBJECTS += gpuirr.o gpunb.o gpupot.o wtime.o cnbint.o cxvpred.o

gpu: $(OBJECTS)
	$(GC) $(FFLAGS) $(OBJECTS) $(LD_GPU) -o nbody6

sse: $(OBJECTS)
	$(GC) $(FFLAGS) $(OBJECTS) $(LD_SSE) -o nbody6

clean:
	rm -f *.o
