      SUBROUTINE UNITS
*
*
*       Initialization of units & scaling factors.
*       ------------------------------------------
*
      INCLUDE 'common6.h'
*
*
*       Define GM, AU and PC in cgs units (2009 IAU values).
      GM = 1.327 124 420 99 D+26
      AU = 1.49597870700 D+13
      PC = 1296000.0D0/TWOPI*AU
*
*       Form scaling factors for binary periods A*SQRT(A/M) to yrs and days.
      YRS = (RBAR*1296000.0D0/TWOPI)**1.5/SQRT(ZMBAR)
      DAYS = 365.25*YRS
*
*       Specify conversion factors for lengths to solar radii & AU.
      RSUN = 6.960D+10
      SU = PC/RSUN*RBAR
      RAU = PC/AU*RBAR
*
*       Copy solar mass scaling to new variable (M = BODY*<M>).
      SMU = ZMBAR
*
*       Form time scale in seconds and velocity scale in km/sec.
      TSTAR = SQRT(PC/GM)*PC
      VSTAR = 1.0D-05*SQRT(GM/PC)
*
*       Convert time scale from units of seconds to million years.
      TSTAR = TSTAR/(3.15576D+07*1.0D+06)
*
*       Ensure ZMBAR & RBAR > 0 (=0: assume <M>/Sun = 1, RBAR = 1 pc).
      IF (ZMBAR.LE.0.0D0) ZMBAR = FLOAT(N)/ZMASS
      IF (RBAR.LE.0.0D0) RBAR = 1.0
*
*       Scale to working units of RBAR in pc & ZMBAR in solar masses.
      TSTAR = TSTAR*SQRT(RBAR**3/(ZMASS*ZMBAR))
      VSTAR = VSTAR*SQRT(ZMASS*ZMBAR/RBAR)
*
*       Copy TSTAR to secondary time-scale factor (just in case).
      TSCALE = TSTAR
*
*       Physical scaling: X, M, V, T from RBAR*X, ZMBAR*M, VSTAR*V, TSTAR*T.
      WRITE (6,10)  RBAR, ZMBAR, VSTAR, TSTAR, BODYM*ZMBAR, SU
   10 FORMAT (/,12X,'PHYSICAL SCALING:    R* =',F5.2,'  M* =',F8.1,
     &              '  V* =',F6.3,'  T* =',F6.3,'  <M> =',F5.2,
     &              '  SU =',1P,E8.1)
*
*       Define relevant parameter for the GR case (RZ = 6*<m>/c^2).
      IF (KZ(27).EQ.3.OR.KZ(28).GT.0) THEN
          CLIGHT = 3.0D+05/VSTAR
          RZ = 6.0*ZMASS/(FLOAT(N)*CLIGHT**2)
          WRITE (6,20)  VSTAR, CLIGHT, RZ
   20     FORMAT (/,12X,'GR SCALING:    V* =',1P,E10.2,'  C =',E10.2,
     &                                  '  RZ =',E10.2)
      ELSE
          RZ = 0.0
          CLIGHT = 0.0
      END IF
*
      RETURN
*
      END
