      SUBROUTINE DATA
*
*
*       Initial conditions for planets.
*       -------------------------------
*
      INCLUDE 'commonp.h'
      REAL*8  AI(150),EI(150),II(150),WI(150),OI(150)
      REAL*8  PX(3),QX(3),XREL(3),VREL(3),XORB(2),VORB(2)
*
*
*       Read initial conditions.
      SCA = 365.25D0 / TWOPI
      DO 1 I = 1,N
          IF (I.EQ.11) THEN
              READ (5,*)  BODY(I), X(1,I), X(2,I), X(3,I), 
     &                    XDOT(1,I), XDOT(2,I), XDOT(3,I),
     &                    A1NGFP, A2NGFP, A3NGFP 
              A1NGFP = A1NGFP * SCA * SCA
              A2NGFP = A2NGFP * SCA * SCA
              A3NGFP = A3NGFP * SCA * SCA
          ELSE
              READ (5,*)  BODY(I), X(1,I), X(2,I), X(3,I), 
     &                    XDOT(1,I), XDOT(2,I), XDOT(3,I)
          END IF
          XDOT(1,I) = -XDOT(1,I) * SCA
          XDOT(2,I) = -XDOT(2,I) * SCA
          XDOT(3,I) = -XDOT(3,I) * SCA
    1 CONTINUE
      SUN = BODY(1)
      DO 2 I = 1,N
          BODY(I) = BODY(I) / SUN 
          IF (I.EQ.11) THEN
              WRITE(6,*)  BODY(I), X(1,I), X(2,I), X(3,I), 
     &                    XDOT(1,I), XDOT(2,I), XDOT(3,I),
     &                    A1NGFP, A2NGFP, A3NGFP
          ELSE
              WRITE(6,*)  BODY(I), X(1,I), X(2,I), X(3,I), 
     &                    XDOT(1,I), XDOT(2,I), XDOT(3,I)
          END IF
    2 CONTINUE
*
*
*       Initialize centre of mass terms.
      DO 25 K = 1,3
          CMR(K) = 0.0D0
          CMRDOT(K) = 0.0D0
   25 CONTINUE
*
      ZMASS = 0.0D0
      DO 40 I = 1,NMASS
          ZMASS = ZMASS + BODY(I)
          DO 35 K = 1,3
              CMR(K) = CMR(K) + BODY(I)*X(K,I)
              CMRDOT(K) = CMRDOT(K) + BODY(I)*XDOT(K,I)
              F(K,I) = 0.0
              FDOT(K,I) = 0.0
              D2(K,I) = 0.0
              D3(K,I) = 0.0
   35     CONTINUE
   40 CONTINUE
*
      DO 50 I = 1,N
          DO 45 K = 1,3
              X(K,I) = X(K,I) - CMR(K)/ZMASS 
              XDOT(K,I) = XDOT(K,I) - CMRDOT(K)/ZMASS 
   45     CONTINUE
   50 CONTINUE
*
*       Define nominal crossing time (cf. initial step and zero velocity).
      TCR = TWOPI
*
      RETURN
*
      END
