      SUBROUTINE XTPERT(M1,M2,X,V,ACC,DER,DT)
*
*
*       Post-Newtonian perturbations.
*       -----------------------------
*
*       L. Blanchet & B. Iyer, Class. Quantum Grav. 20 (2003), 755.
*       T. Mora & Clifford Will, gr-qc/0312082.
*       ---------------------------------------
*
      IMPLICIT REAL*8  (A-H,M,O-Z)
      COMMON/POSTN/  CLIGHT,RZ,GAM,DEGR,IPN
      PARAMETER (ONE12=1.0/12.0D0)
      REAL*8  ACC(3),DER(3),VDOT(3),X(3),V(3)
      SAVE ED0,ED20
      DATA ED0,ED20 /2*0.0D0/
      SAVE IC
      DATA IC /0/
*
*
*       Set total mass and reduced mass parameter.
      M = M1 + M2
      ETA = M1*M2/M**2
      ZMU = M*ETA
*
*       Form useful scalars.
      R2 = X(1)**2 + X(2)**2 + X(3)**2
      R = SQRT(R2)
      MR = M/R
      V2 = V(1)**2 + V(2)**2 + V(3)**2
      RD = (X(1)*V(1) + X(2)*V(2) + X(3)*V(3))/R
*
*       Define unscaled PN2.5 (positive sign convention).
      A25 = 8.0/5.0*ETA*MR*RD*(17.0/3.0*MR + 3.0*V2)
      A = A25
*
      B25 = -8.0/5.0*ETA*MR*(3.0*MR + V2)
      B = B25
*
*       Set the standard PN2.5 acceleration scaled by M/R**2/C**5.
      DO 5 K = 1,3
          ACC(K) = M/R2*(A*X(K)/R + B*V(K))/CLIGHT**5
    5 CONTINUE
*
*       Form terms for the first time derivative of A & B.
      RVD = 0.0
      VVDOT = 0.0
      DO 10 K = 1,3
          VDOT(K) = ACC(K) - MR*X(K)/R2
          RVD = RVD + X(K)*VDOT(K)
          VVDOT = VVDOT + V(K)*VDOT(K)
   10 CONTINUE
*
*       Obtain d2R/dt**2 from dR/dt & d(R*V)/dt and absorb 1/R in ADOT.
      RD2 = V2 + RVD - RD**2
*
*       Adopt Peter Berczik's A & B derivatives (these have correct sign!).
      ADOT = (17.0/3.0*MR + 3.0*V2)*(RD2 - RD**2)*M/R2 +
     &       MR*RD*(-17.0/3.0*M*RD/R2 + 6.0*VVDOT)
      BDOT = MR*((3.0*MR + V2)*RD/R + 3.0*M*RD/R2 - 2.0*VVDOT)
      ADOT = 1.6*ETA*ADOT
      BDOT = 1.6*ETA*BDOT
*
*       Use equation of motion dV/dt = M/R2*((-1 + A/C**5)*X/R + B*V/C**5).
      DO 20 K = 1,3
*       Note that M/R2 is omitted in all terms (set in final scaling).
          DER(K) = -2.0*RD/R*(A*X(K)/R + B*V(K)) + ADOT*X(K)/R -
     &              A*RD*X(K)/R2 + A*V(K)/R + BDOT*V(K) + B*VDOT(K)
          DER(K) = DER(K)/CLIGHT**3
   20 CONTINUE
*
*       Scale derivative by the leading term M/R**2 and also by 1/C**2.
      GMC = M/(CLIGHT**2*R2)
      GAM = 0.0
      DO 30 K = 1,3
          DER(K) = GMC*DER(K)
          GAM = GAM + ACC(K)**2
   30 CONTINUE
*
*       Employ Hermite 4th-order integration for the energy equation.
      ED = 0.0
      ED2 = 0.0
*       Form the first and second energy derivative.
      DO 40 K = 1,3
          ED = ED + ACC(K)*V(K)
          ED2 = ED2 + ACC(K)*VDOT(K) + DER(K)*V(K)
   40 CONTINUE
*
*       Construct standard Hermite third and fourth-order derivatives.
***   ED3 = 2.0*(-3.0*(ED0 - ED) - (2.0*ED20 + ED2)*DT)/DT**2
***   ED4 = 6.0*(2.0*(ED0 - ED) + (ED20 + ED2)*DT)/DT**3
*
*       Get final result from Keigo's Hermite corrector.
      DE = 0.5*(ED0 + ED)*DT + ONE12*(ED20 - ED2)*DT**2
      DEGR = DEGR + ZMU*DE
*
*       Save the two derivatives for next step.
      ED0 = ED
      ED20 = ED2
*
      IC = IC + 1
*       Define relative perturbation for time-step reduction (no dyn pert).
      GAM = SQRT(GAM)*R2/M
      IF (MOD(IC,100).EQ.0) THEN
      DD = SQRT(DER(1)**2 + DER(2)**2)
      WRITE (6,60)  IC, GAM, R, DD, A, B, DEGR
   60 FORMAT (' IC GAM R DD A B DEGR ',I9,1P,6E10.2)
      END IF
*
      RETURN
*
      END
